/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private StringUtils() {
    }

    public static int safeLength(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static int maxWidth(Vector v) {
        int max = 0;
        if (v == null || v.size() <= 0 || !(v.elementAt(0) instanceof String)) {
            return 0;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            int len = ((String)v.elementAt(i)).length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public static boolean isHex(String s) {
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            if (StringUtils.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        String hex = "0123456789abcdefABCDEF";
        int hexlen = hex.length();
        for (int i = 0; i < hexlen; ++i) {
            if (hex.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String getPenultimateDirName(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        if (s.indexOf(47) < 0 && s.indexOf(92) < 0) {
            return "";
        }
        int index = (s = s.replace('\\', '/')).lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        if ((index = (s = s.substring(0, index)).lastIndexOf(47)) >= 0) {
            s = s.substring(index + 1);
        }
        return s;
    }

    public static String toShortClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String padRight(String s, int len) {
        if (s == null || s.length() >= len) {
            return s;
        }
        for (int i = len - s.length(); i > 0; --i) {
            s = s + ' ';
        }
        return s;
    }

    public static String padLeft(String s, int len) {
        String ss = "";
        if (s == null || s.length() >= len) {
            return s;
        }
        for (int i = len - s.length(); i > 0; --i) {
            ss = ss + ' ';
        }
        return ss + s;
    }

    public static String[] toLines(String s) {
        if (s == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        int start = 0;
        int end = 0;
        end = s.indexOf(10, start);
        while (end >= 0 && start < s.length()) {
            v.addElement(s.substring(start, end));
            start = end + 1;
            end = s.indexOf(10, start);
        }
        if (start < s.length()) {
            v.addElement(s.substring(start));
        }
        Object[] ss = new String[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public static void prepend(String[] ss, String what) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = what + ss[i];
        }
    }

    public static String UpperCaseFirstLetter(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        String ret = s.substring(0, index);
        ret = ret + replace;
        ret = ret + s.substring(index + tokenLength);
        return ret;
    }

    public static String toString(Properties props) {
        String key;
        if (props == null || props.size() <= 0) {
            return "No entries";
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        StringBuffer sb = new StringBuffer();
        int keyWidth = 0;
        for (Map.Entry<Object, Object> me : entries) {
            key = (String)me.getKey();
            int len = key.length();
            if (len <= keyWidth) continue;
            keyWidth = len;
        }
        ++keyWidth;
        for (Map.Entry<Object, Object> me : entries) {
            key = (String)me.getKey();
            String val = (String)me.getValue();
            sb.append(StringUtils.padRight(key, keyWidth));
            sb.append("= ");
            sb.append(val);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len == 1 && args[0].equalsIgnoreCase("toLine")) {
            StringUtils.testToLine();
        } else if (len > 1 && args[0].equalsIgnoreCase("isHex")) {
            StringUtils.testHex(args);
        } else {
            StringUtils.usage();
        }
    }

    private static void usage() {
        System.out.println("StringUtils -- main() for testing usage:\n");
        System.out.println("java netscape.blizzard.util.StringUtils toLine");
        System.out.println("java netscape.blizzard.util.StringUtils isHex number1 number2 ...");
    }

    private static void testHex(String[] args) {
        System.out.println("StringUtils -- Testing Hex");
        for (int i = 1; i < args.length; ++i) {
            System.out.println(StringUtils.padRight(args[i], 16) + "  " + (StringUtils.isHex(args[i]) ? "yesHex" : "notHex"));
        }
    }

    private static void testToLine() {
        System.out.println("StringUtils -- Testing toLine()");
        String[] ss = new String[]{null, "", "abc\ndef\n", "abc\ndef", "abc", "abc\n", "abc\n\n", "q", "\n\nk\n\nz\n\n", "sd.adj;ld"};
        for (int k = 0; k < ss.length; ++k) {
            String[] s2 = StringUtils.toLines(ss[k]);
            System.out.println("String #" + k + ", Number of Lines:  " + s2.length);
            for (int i = 0; i < s2.length; ++i) {
                System.out.println(s2[i]);
            }
        }
    }

    public static void testUpperCase() {
        String[] test = new String[]{"xyz", "HITHERE", "123aa", "aSSS", "yothere"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println(test[i] + " >>> " + StringUtils.UpperCaseFirstLetter(test[i]));
        }
    }

    public static String makeFilePath(String[] strings, boolean addTrailing) {
        StringBuffer path = null;
        String separator = System.getProperty("file.separator");
        if (strings != null) {
            path = new StringBuffer();
            for (int i = 0; i < strings.length; ++i) {
                String element = strings[i];
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException();
                }
                path.append(element);
                if (i >= strings.length - 1) continue;
                path.append(separator);
            }
            if (addTrailing) {
                path.append(separator);
            }
        }
        return path.toString();
    }

    public static List parseStringList(String line) {
        return StringUtils.parseStringList(line, null);
    }

    public static List<String> parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        Vector<String> tokens = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

