/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DirectoryMover;
import com.sun.enterprise.tools.upgrade.common.InteractiveInput;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_source;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_target;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Console;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;

public class InteractiveInputImpl
implements DirectoryMover,
InteractiveInput {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager sm = StringManager.getManager(InteractiveInputImpl.class);
    private static final CommonInfoModel commonInfoModel = CommonInfoModel.getInstance();
    private static final Console console = System.console();
    private Map<String, ArgumentHandler> inputMap;

    @Override
    public void processArguments(ArrayList<ArgumentHandler> aList) {
        if (console == null) {
            throw new RuntimeException("CLI cannot be used with null console");
        }
        int cnt = aList.size();
        this.inputMap = new HashMap<String, ArgumentHandler>();
        for (int i = 0; i < cnt; ++i) {
            ArgumentHandler tmpAh = aList.get(i);
            this.inputMap.put(tmpAh.getCmd(), tmpAh);
        }
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(LogService.createFormatter());
        logger.addHandler(handler);
        this.sourcePrompt();
        this.targetPrompt();
        if (!CommonInfoModel.getInstance().isUpgradeSupported()) {
            System.exit(1);
        }
        this.masterPasswordPrompt();
    }

    private void sourcePrompt() {
        ArgumentHandler tmpA = this.inputMap.get("s");
        if (tmpA == null) {
            tmpA = this.inputMap.get("source");
        }
        if (tmpA == null) {
            String source = console.readLine(sm.getString("enterprise.tools.upgrade.cli.Source_input"), new Object[0]);
            tmpA = new ARG_source();
            tmpA.setRawParameters(source);
            this.inputMap.put("source", tmpA);
        }
        if (tmpA.isValidParameter()) {
            tmpA.exec();
        } else {
            System.err.println(sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
            this.inputMap.remove("s");
            this.inputMap.remove("source");
            this.sourcePrompt();
        }
    }

    private void targetPrompt() {
        ArgumentHandler tmpA = this.inputMap.get("t");
        if (tmpA == null) {
            tmpA = this.inputMap.get("target");
        }
        if (tmpA == null) {
            String target = console.readLine(sm.getString("enterprise.tools.upgrade.cli.Target_input"), new Object[0]);
            tmpA = new ARG_target();
            tmpA.setRawParameters(target);
            this.inputMap.put("target", tmpA);
        }
        tmpA.getCommonInfo().getTarget().setDirectoryMover(this);
        if (tmpA.isValidParameter()) {
            tmpA.exec();
        } else {
            System.err.println(sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
            this.inputMap.remove("t");
            this.inputMap.remove("target");
            this.targetPrompt();
        }
    }

    private void masterPasswordPrompt() {
        char[] passwordChars = console.readPassword(sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"), new Object[0]);
        if (passwordChars.length > 0) {
            commonInfoModel.getSource().getDomainCredentials().setMasterPassword(passwordChars);
        }
    }

    @Override
    public boolean moveDirectory(File dir) {
        String no = sm.getString("enterprise.tools.upgrade.cli.no_option");
        String yes = sm.getString("enterprise.tools.upgrade.cli.yes_option");
        System.out.print(sm.getString("enterprise.tools.upgrade.cli.move_dir", dir.getName(), yes, no));
        String response = console.readLine();
        while (!yes.equals(response) && !no.equals(response)) {
            System.err.print(sm.getString("enterprise.tools.upgrade.cli.move_dir_responses", yes, no));
            response = console.readLine();
        }
        boolean move = yes.equalsIgnoreCase(response);
        if (move) {
            UpgradeUtils.getUpgradeUtils(commonInfoModel).rename(dir);
        }
        return move;
    }
}

