/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntry;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOn
extends GlassFishSingleSignOn {
    private static final Logger logger = LogDomains.getLogger(HASingleSignOn.class, (String)"javax.enterprise.system.container.web");
    private BackingStore ssoEntryMetadataBackingStore = null;
    private JavaEEIOUtils ioUtils = null;

    public HASingleSignOn(JavaEEIOUtils ioUtils, BackingStore ssoEntryMetadataBackingStore) {
        this.ioUtils = ioUtils;
        this.ssoEntryMetadataBackingStore = ssoEntryMetadataBackingStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        sso.expireSessions();
        try {
            this.ssoEntryMetadataBackingStore.remove((Serializable)((Object)ssoId));
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HASingleSignOnEntry ssoEntry = null;
        Map map = this.cache;
        synchronized (map) {
            ssoEntry = new HASingleSignOnEntry(ssoId, principal, authType, username, realmName, System.currentTimeMillis(), 1000000L, 0L, this.ioUtils);
            this.cache.put(ssoId, ssoEntry);
        }
        try {
            this.ssoEntryMetadataBackingStore.save((Serializable)((Object)ssoId), (Serializable)ssoEntry.getMetadata(), true);
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void associate(String ssoId, Session session) {
        HASingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = (HASingleSignOnEntry)this.lookup(ssoId)) != null) {
            sso.addSession(this, session);
            try {
                this.ssoEntryMetadataBackingStore.save((Serializable)((Object)ssoId), (Serializable)sso.getMetadata(), false);
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected SingleSignOnEntry lookup(String ssoId) {
        SingleSignOnEntry ssoEntry = super.lookup(ssoId);
        if (ssoEntry == null) {
            try {
                HASingleSignOnEntryMetadata mdata = (HASingleSignOnEntryMetadata)this.ssoEntryMetadataBackingStore.load((Serializable)((Object)ssoId), null);
                if (mdata != null) {
                    ssoEntry = new HASingleSignOnEntry(this.getContainer(), mdata, this.ioUtils);
                    this.cache.put(ssoId, ssoEntry);
                }
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return ssoEntry;
    }

    protected void removeSession(String ssoId, Session session) {
        HASingleSignOnEntry entry;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing session " + session.toString() + " from sso id " + ssoId);
        }
        if ((entry = (HASingleSignOnEntry)this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        if (entry.isEmpty()) {
            this.deregister(ssoId);
        } else {
            try {
                this.ssoEntryMetadataBackingStore.save((Serializable)((Object)ssoId), (Serializable)entry.getMetadata(), false);
            }
            catch (BackingStoreException ex) {
                // empty catch block
            }
        }
    }
}

