/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.appserv.connectors.internal.spi.ConnectionManager;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.allocator.ConnectorAllocator;
import com.sun.enterprise.resource.allocator.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.allocator.NoTxConnectorAllocator;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.RetryableUnavailableException;
import javax.security.auth.Subject;
import org.glassfish.resource.common.PoolInfo;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    protected String jndiName;
    protected String logicalName;
    protected PoolInfo poolInfo;
    private static Logger logger = LogDomains.getLogger(ConnectionManagerImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
    protected String rarName;
    protected ResourcePrincipal defaultPrin = null;

    public ConnectionManagerImpl(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setPoolInfo(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public Object allocateNonTxConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String localJndiName = this.jndiName;
        this.logFine("Allocating NonTxConnection");
        if (!this.jndiName.endsWith("__nontx")) {
            localJndiName = this.jndiName + "__nontx";
            this.logFine("Adding __nontx to jndiname");
        } else {
            this.logFine("lookup happened from a __nontx datasource directly");
        }
        return this.allocateConnection(mcf, cxRequestInfo, localJndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, this.jndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, String jndiNameToUse) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, jndiNameToUse, null);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, String jndiNameToUse, Object conn) throws ResourceException {
        AuthenticationService authService;
        this.validatePool();
        PoolManager poolmgr = ConnectorRuntime.getRuntime().getPoolManager();
        boolean resourceShareable = true;
        ResourceReferenceDescriptor ref = poolmgr.getResourceReference(jndiNameToUse, this.logicalName);
        if (ref != null) {
            String shareableStr = ref.getSharingScope();
            if (shareableStr.equals("Unshareable")) {
                resourceShareable = false;
            }
        }
        if (ref == null) {
            ConnectionManagerImpl.getLogger().log(Level.FINE, "poolmgr.no_resource_reference", jndiNameToUse);
            return this.internalGetConnection(mcf, this.defaultPrin, cxRequestInfo, resourceShareable, jndiNameToUse, conn, true);
        }
        String auth = ref.getAuthorization();
        if (auth.equals("Application")) {
            if (cxRequestInfo == null) {
                String msg = ConnectionManagerImpl.getLocalStrings().getString("con_mgr.null_userpass");
                throw new ResourceException(msg);
            }
            ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolInfo);
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable, jndiNameToUse, conn, false);
        }
        ResourcePrincipal prin = null;
        Set principalSet = null;
        Principal callerPrincipal = null;
        SecurityContext securityContext = null;
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        if (connectorRuntime.isServer() && (securityContext = SecurityContext.getCurrent()) != null && (callerPrincipal = securityContext.getCallerPrincipal()) != null && (principalSet = securityContext.getPrincipalSet()) != null && (authService = connectorRuntime.getAuthenticationService(this.rarName, this.poolInfo)) != null) {
            prin = (ResourcePrincipal)authService.mapPrincipal(callerPrincipal, principalSet);
        }
        if (prin == null) {
            prin = ref.getResourcePrincipal();
            if (prin == null) {
                ConnectionManagerImpl.getLogger().log(Level.FINE, "default-resource-principal notspecified for " + jndiNameToUse + ". Defaulting to" + " user/password specified in the pool");
                prin = this.defaultPrin;
            } else if (!prin.equals((Object)this.defaultPrin)) {
                ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolInfo);
            }
        }
        return this.internalGetConnection(mcf, prin, cxRequestInfo, resourceShareable, jndiNameToUse, conn, false);
    }

    protected Object internalGetConnection(ManagedConnectionFactory mcf, ResourcePrincipal prin, ConnectionRequestInfo cxRequestInfo, boolean shareable, String jndiNameToUse, Object conn, boolean isUnknownAuth) throws ResourceException {
        try {
            PoolManager poolmgr = ConnectorRuntime.getRuntime().getPoolManager();
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            PoolMetaData pmd = registry.getPoolMetaData(this.poolInfo);
            ResourceSpec spec = new ResourceSpec(jndiNameToUse, 1, pmd);
            spec.setPoolInfo(this.poolInfo);
            ManagedConnectionFactory freshMCF = pmd.getMCF();
            if (ConnectionManagerImpl.getLogger().isLoggable(Level.INFO) && !freshMCF.equals(mcf)) {
                ConnectionManagerImpl.getLogger().info("conmgr.mcf_not_equal");
            }
            ConnectorDescriptor desc = registry.getDescriptor(this.rarName);
            Subject subject = null;
            ClientSecurityInfo info = null;
            boolean subjectDefined = false;
            if (isUnknownAuth && this.rarName.equals("jmsra") && !pmd.isAuthCredentialsDefinedInPool()) {
                subject = ConnectionPoolObjectsUtils.createSubject(mcf, null);
            } else if (prin == null) {
                info = new ClientSecurityInfo(cxRequestInfo);
            } else {
                info = new ClientSecurityInfo(prin);
                if (subject == null) {
                    subject = prin.equals((Object)this.defaultPrin) ? pmd.getSubject() : ConnectionPoolObjectsUtils.createSubject(mcf, prin);
                }
            }
            int txLevel = pmd.getTransactionSupport();
            if (ConnectionManagerImpl.getLogger().isLoggable(Level.FINE)) {
                this.logFine("ConnectionMgr: poolName " + this.poolInfo + "  txLevel : " + txLevel);
            }
            return this.getResource(txLevel, poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
        }
        catch (PoolingException ex) {
            Object[] params = new Object[]{this.poolInfo, ex};
            ConnectionManagerImpl.getLogger().log(Level.WARNING, "poolmgr.get_connection_failure", params);
            String i18nMsg = ConnectionManagerImpl.getLocalStrings().getString("con_mgr.error_creating_connection", (Object)ex.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(i18nMsg);
            rae.initCause((Throwable)ex);
            throw rae;
        }
    }

    private Object getResource(int txLevel, PoolManager poolmgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo cxRequestInfo, ClientSecurityInfo info, ConnectorDescriptor desc, boolean shareable) throws PoolingException, ResourceAllocationException, IllegalStateException, RetryableUnavailableException {
        AbstractConnectorAllocator alloc2;
        switch (txLevel) {
            case 0: {
                alloc2 = new NoTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                break;
            }
            case 1: {
                alloc2 = new LocalTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
                break;
            }
            case 2: {
                if (this.rarName.equals("jmsra")) {
                    shareable = false;
                }
                spec.markAsXA();
                ConnectorAllocator alloc2 = new ConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
                return poolmgr.getResource(spec, alloc2, info);
            }
            default: {
                String i18nMsg = ConnectionManagerImpl.getLocalStrings().getString("con_mgr.illegal_tx_level", (Object)(txLevel + " "));
                throw new IllegalStateException(i18nMsg);
            }
        }
        return poolmgr.getResource(spec, alloc2, info);
    }

    public void setRarName(String _rarName) {
        this.rarName = _rarName;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void initialize() throws ConnectorRuntimeException {
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        if (runtime.isNonACCRuntime()) {
            this.jndiName = ConnectorsUtil.getPMJndiName((String)this.jndiName);
        }
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        PoolMetaData pmd = registry.getPoolMetaData(this.poolInfo);
        this.defaultPrin = pmd.getResourcePrincipal();
    }

    private void validatePool() throws ResourceException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (registry.getPoolMetaData(this.poolInfo) == null) {
            String msg = ConnectionManagerImpl.getLocalStrings().getString("con_mgr.no_pool_meta_data", (Object)this.poolInfo);
            throw new ResourceException(this.poolInfo + ": " + msg);
        }
    }

    public void logFine(String message) {
        if (ConnectionManagerImpl.getLogger().isLoggable(Level.FINE)) {
            ConnectionManagerImpl.getLogger().fine(message);
        }
    }

    private static StringManager getLocalStrings() {
        if (localStrings == null) {
            localStrings = StringManager.getManager(ConnectionManagerImpl.class);
        }
        return localStrings;
    }

    protected static Logger getLogger() {
        if (logger == null) {
            logger = LogDomains.getLogger(ConnectionManagerImpl.class, (String)"javax.enterprise.resource.resourceadapter");
        }
        return logger;
    }
}

