/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.beans.CustomResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class CustomResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager(CustomResourceDeployer.class);
    @Inject
    private ResourceNamingService cns;
    private static Logger _logger = LogDomains.getLogger(CustomResourceDeployer.class, (String)"javax.enterprise.system.core");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        com.sun.enterprise.config.serverbeans.CustomResource customResource = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(customResource.getJndiName(), applicationName, moduleName);
        this.deployResource(resource, resourceInfo);
    }

    public synchronized void deployResource(Object resource) throws Exception {
        com.sun.enterprise.config.serverbeans.CustomResource customResource = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)customResource);
        this.deployResource(customResource, resourceInfo);
    }

    private void deployResource(Object resource, ResourceInfo resourceInfo) {
        com.sun.enterprise.config.serverbeans.CustomResource customRes = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        if (ConnectorsUtil.parseBoolean((String)customRes.getEnabled())) {
            JavaEEResource j2eeResource = CustomResourceDeployer.toCustomJavaEEResource(customRes, resourceInfo);
            this.installCustomResource((CustomResource)j2eeResource, resourceInfo);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{customRes.getJndiName(), "custom"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        com.sun.enterprise.config.serverbeans.CustomResource customRes = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)customRes);
        this.cns.unpublishObject((GenericResourceInfo)resourceInfo, resourceInfo.getName());
    }

    public boolean handles(Object resource) {
        return resource instanceof com.sun.enterprise.config.serverbeans.CustomResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installCustomResource(CustomResource customRes, ResourceInfo resourceInfo) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "installCustomResource by jndi-name : " + resourceInfo);
            }
            Reference ref = new Reference(customRes.getResType(), customRes.getFactoryClass(), null);
            for (ResourceProperty prop : customRes.getProperties()) {
                ref.add(new StringRefAddr(prop.getName(), (String)prop.getValue()));
            }
            this.cns.publishObject(resourceInfo, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", resourceInfo);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public static JavaEEResource toCustomJavaEEResource(com.sun.enterprise.config.serverbeans.CustomResource rbean, ResourceInfo resourceInfo) {
        CustomResource jr = new CustomResource(resourceInfo);
        jr.setEnabled(ConnectorsUtil.parseBoolean((String)rbean.getEnabled()));
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                jr.addProperty((ResourceProperty)rp);
            }
        }
        return jr;
    }
}

