/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolLifeCycleRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolEmitterImpl;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProviderUtil;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolStatsProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolStatsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectionPoolStatsProviderBootstrap
implements PostConstruct,
PoolLifeCycle {
    @Inject
    Logger logger;
    @Inject
    private PoolManager poolManager;
    @Inject
    private Habitat habitat;
    private List<JdbcConnPoolStatsProvider> jdbcStatsProviders = new ArrayList<JdbcConnPoolStatsProvider>();
    private List<ConnectorConnPoolStatsProvider> ccStatsProviders = new ArrayList<ConnectorConnPoolStatsProvider>();
    private Map<PoolInfo, ConnectionPoolEmitterImpl> poolEmitters = new HashMap<PoolInfo, ConnectionPoolEmitterImpl>();
    private Map<PoolInfo, PoolLifeCycleListenerRegistry> poolRegistries = new HashMap<PoolInfo, PoolLifeCycleListenerRegistry>();
    private ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public void addToPoolEmitters(PoolInfo poolInfo, ConnectionPoolEmitterImpl emitter) {
        this.poolEmitters.put(poolInfo, emitter);
    }

    public void registerProvider() {
        this.registerPoolLifeCycleListener();
    }

    public void postConstruct() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("[Monitor]In the JDBCPoolStatsProviderBootstrap");
        }
    }

    private PoolLifeCycleListenerRegistry registerPool(PoolInfo poolInfo, ConnectionPoolProbeProvider poolProvider) {
        PoolLifeCycleListenerRegistry poolRegistry = null;
        if (this.poolRegistries.get(poolInfo) == null) {
            poolRegistry = new PoolLifeCycleListenerRegistry(poolInfo);
            this.poolRegistries.put(poolInfo, poolRegistry);
        } else {
            poolRegistry = this.poolRegistries.get(poolInfo);
        }
        ConnectionPoolEmitterImpl emitter = new ConnectionPoolEmitterImpl(poolInfo, poolProvider);
        poolRegistry.registerPoolLifeCycleListener(emitter);
        this.addToPoolEmitters(poolInfo, emitter);
        return poolRegistry;
    }

    public Resources getResources() {
        return (Resources)this.habitat.getComponent(Resources.class);
    }

    public ConnectionPoolProbeProviderUtil getProbeProviderUtil() {
        return (ConnectionPoolProbeProviderUtil)this.habitat.getComponent(ConnectionPoolProbeProviderUtil.class);
    }

    private void registerJdbcPool(PoolInfo poolInfo) {
        if (this.poolManager.getPool(poolInfo) != null) {
            this.getProbeProviderUtil().createJdbcProbeProvider();
            JdbcConnPoolStatsProvider jdbcPoolStatsProvider = new JdbcConnPoolStatsProvider(poolInfo, this.logger);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)ConnectorsUtil.getPoolMonitoringSubTreeRoot((PoolInfo)poolInfo), (Object)jdbcPoolStatsProvider);
            PoolLifeCycleListenerRegistry registry = this.registerPool(poolInfo, this.getProbeProviderUtil().getJdbcProbeProvider());
            jdbcPoolStatsProvider.setPoolRegistry(registry);
            this.jdbcStatsProviders.add(jdbcPoolStatsProvider);
        }
    }

    private void registerCcPool(PoolInfo poolInfo) {
        if (this.poolManager.getPool(poolInfo) != null) {
            this.getProbeProviderUtil().createJcaProbeProvider();
            ConnectorConnPoolStatsProvider ccPoolStatsProvider = new ConnectorConnPoolStatsProvider(poolInfo, this.logger);
            StatsProviderManager.register((String)"connector-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)ConnectorsUtil.getPoolMonitoringSubTreeRoot((PoolInfo)poolInfo), (Object)ccPoolStatsProvider);
            PoolLifeCycleListenerRegistry registry = this.registerPool(poolInfo, this.getProbeProviderUtil().getJcaProbeProvider());
            ccPoolStatsProvider.setPoolRegistry(registry);
            this.ccStatsProviders.add(ccPoolStatsProvider);
        }
    }

    private void registerPoolLifeCycleListener() {
        if (this.runtime.isServer()) {
            PoolLifeCycleRegistry poolLifeCycleRegistry = PoolLifeCycleRegistry.getRegistry();
            poolLifeCycleRegistry.registerPoolLifeCycle(this);
        }
    }

    private void unregisterPool(PoolInfo poolInfo) {
        PoolLifeCycleListenerRegistry poolRegistry;
        Iterator<Object> i;
        if (this.jdbcStatsProviders != null) {
            i = this.jdbcStatsProviders.iterator();
            while (i.hasNext()) {
                JdbcConnPoolStatsProvider jdbcPoolStatsProvider = (JdbcConnPoolStatsProvider)i.next();
                if (!poolInfo.equals((Object)jdbcPoolStatsProvider.getPoolInfo())) continue;
                poolRegistry = jdbcPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolInfo);
                StatsProviderManager.unregister((Object)jdbcPoolStatsProvider);
                i.remove();
            }
        }
        if (this.ccStatsProviders != null) {
            i = this.ccStatsProviders.iterator();
            while (i.hasNext()) {
                ConnectorConnPoolStatsProvider ccPoolStatsProvider = (ConnectorConnPoolStatsProvider)i.next();
                if (!poolInfo.equals((Object)ccPoolStatsProvider.getPoolInfo())) continue;
                poolRegistry = ccPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolInfo);
                StatsProviderManager.unregister((Object)ccPoolStatsProvider);
                i.remove();
            }
        }
        this.unregisterPoolAppProviders(poolInfo);
        this.poolRegistries.remove(poolInfo);
    }

    public void unregisterPoolAppProviders(PoolInfo poolInfo) {
        ConnectionPoolEmitterImpl emitter = this.poolEmitters.get(poolInfo);
        if (emitter != null) {
            emitter.unregisterAppStatsProviders();
        }
    }

    public boolean getEnabledValue(String strEnabled) {
        return !"OFF".equals(strEnabled);
    }

    public void poolCreated(PoolInfo poolInfo) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Pool created : " + poolInfo);
        }
        if (this.runtime.isServer()) {
            ResourcePool pool = this.runtime.getConnectionPoolConfig(poolInfo);
            if (pool instanceof JdbcConnectionPool) {
                this.registerJdbcPool(poolInfo);
            } else if (pool instanceof ConnectorConnectionPool) {
                this.registerCcPool(poolInfo);
            }
        }
    }

    public void poolDestroyed(PoolInfo poolInfo) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Pool Destroyed : " + poolInfo);
        }
        if (this.runtime.isServer()) {
            this.unregisterPool(poolInfo);
        }
    }
}

