/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.util;

import java.util.BitSet;
import java.util.logging.Logger;

public class HtmlEntityEncoder {
    private static final Logger log = Logger.getLogger(HtmlEntityEncoder.class.getName());
    protected BitSet safeCharacters = new BitSet(256);

    public HtmlEntityEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        this.addSafeCharacter('$');
        this.addSafeCharacter('_');
        this.addSafeCharacter('.');
        this.addSafeCharacter('!');
        this.addSafeCharacter('*');
        this.addSafeCharacter('\\');
        this.addSafeCharacter(',');
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.encode(obj.toString());
    }

    public String encode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (this.safeCharacters.get(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append("&#").append((int)c).append(";");
                continue;
            }
            if (Character.isISOControl(c)) continue;
            if (Character.isHighSurrogate(c)) {
                int codePoint;
                if (i + 1 < s.length() && Character.isLowSurrogate(s.charAt(i + 1)) && Character.isDefined(codePoint = Character.toCodePoint(c, s.charAt(i + 1)))) {
                    sb.append("&#").append(codePoint).append(";");
                }
                ++i;
                continue;
            }
            if (!Character.isDefined(c)) continue;
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append("&#").append((int)c).append(";");
                }
            }
        }
        return sb.toString();
    }
}

