/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-domains")
@Scoped(value=PerLookup.class)
public final class ListDomainsCommand
extends LocalDomainCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);
    private String domainsRoot = null;

    protected void validate() throws CommandException, CommandValidationException {
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            File domainsDirFile = ListDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
            DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            this.programOpts.setInteractive(false);
            if (domainsList.length > 0) {
                for (String dn : domainsList) {
                    String status = this.getStatus(dn);
                    logger.printMessage(strings.get("list.domains.Output", new Object[]{dn, status}));
                }
            } else {
                logger.printDetailMessage(strings.get("NoDomainsToList"));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return 0;
    }

    private String getStatus(String dn) throws IOException, CommandException {
        this.setDomainName(dn);
        this.initDomain();
        this.programOpts.setPort(this.getAdminPort());
        boolean status = this.isThisDAS(this.getDomainRootDir());
        if (status) {
            try {
                RemoteCommand cmd = new RemoteCommand("_get-restart-required", this.programOpts, this.env);
                String restartRequired = cmd.executeAndReturnOutput(new String[]{"_get-restart-required"});
                if (Boolean.parseBoolean(restartRequired.trim())) {
                    return strings.get("list.domains.StatusRestartRequired");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return strings.get("list.domains.StatusRunning");
        }
        return strings.get("list.domains.StatusNotRunning");
    }
}

