/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.Date;

public class PlatformServicesInfo {
    final ServerDirs serverDirs;
    final AppserverServiceType type;
    String fqsn;
    String serviceName;
    boolean dryRun;
    String osUser;
    boolean trace;
    File libDir;
    String smfFullServiceName;
    File asadminScript;
    boolean force;
    String serviceUser;
    Date date;
    File passwordFile;
    String appserverUser;
    private boolean valid;
    private File installRootDir;

    public PlatformServicesInfo(ServerDirs sDirs, AppserverServiceType theType) {
        this.serverDirs = sDirs;
        if (this.serverDirs == null || this.serverDirs.getServerDir() == null) {
            throw new RuntimeException(Strings.get("bad.server.dirs"));
        }
        this.type = theType;
    }

    public void validate() {
        if (!StringUtils.ok((String)this.serviceName)) {
            this.serviceName = this.serverDirs.getServerName();
        }
        this.date = new Date();
        this.setInstallRootDir();
        this.setLibDir();
        this.setAsadmin();
        this.osUser = System.getProperty("user.name");
        this.fqsn = this.serverDirs.getServerName() + this.serverDirs.getServerParentDir().getPath().replace('/', '_');
        this.smfFullServiceName = "application/GlassFish/" + this.serviceName;
        this.valid = true;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setServiceUser(String serviceUser) {
        this.serviceUser = serviceUser;
    }

    public void setAppServerUser(String user) {
        if (StringUtils.ok((String)user)) {
            this.appserverUser = user;
        }
    }

    private void setLibDir() {
        this.libDir = SmartFile.sanitize((File)new File(this.installRootDir, "lib"));
        if (!this.libDir.isDirectory()) {
            throw new RuntimeException(Strings.get("internal.error", "Not a directory: " + this.libDir));
        }
    }

    private void setInstallRootDir() {
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)ir)) {
            throw new RuntimeException(Strings.get("internal.error", "System Property not set: com.sun.aas.installRoot"));
        }
        this.installRootDir = SmartFile.sanitize((File)new File(ir));
        if (!this.installRootDir.isDirectory()) {
            throw new RuntimeException(Strings.get("internal.error", "Not a directory: " + this.installRootDir));
        }
    }

    private void setAsadmin() {
        String s = SystemPropertyConstants.getAsAdminScriptLocation();
        if (!StringUtils.ok((String)s)) {
            throw new RuntimeException(Strings.get("internal.error", "Can't get Asadmin script location"));
        }
        this.asadminScript = SmartFile.sanitize((File)new File(s));
        if (!this.asadminScript.isFile()) {
            throw new RuntimeException(Strings.get("noAsadminScript", this.asadminScript));
        }
    }
}

