/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class SaveCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private V v;
    private transient byte[] rawReadState;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
    }

    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
    }

    @Override
    protected SaveCommand<K, V> createNewInstance() {
        return new SaveCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        super.selectReplicaInstance(this.k);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        this.dsc.getDataStoreEntryHelper().writeObject(ros, this.v);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.v = this.dsc.getDataStoreEntryHelper().readObject(ris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            entry.setV(this.v);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }
}

