/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class StoreableRemoveCommand<K, V>
extends Command<K, V> {
    protected static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.remove");
    private K key;

    public StoreableRemoveCommand() {
        super((byte)71);
    }

    public StoreableRemoveCommand(K key) {
        this();
        this.key = key;
    }

    @Override
    protected StoreableRemoveCommand<K, V> createNewInstance() {
        return new StoreableRemoveCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        super.setTargetName(null);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.key);
        synchronized (dataStoreEntry) {
            entry.markAsRemoved("Removed by removeCommand from " + initiator);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

