/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class TouchCommand<K, V>
extends Command<K, V> {
    private K k;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private long version;
    private long accessTime;
    private long maxIdleTime;

    public TouchCommand() {
        super((byte)38);
    }

    public TouchCommand(K k, long version, long accessTime, long maxIdleTime) {
        this();
        this.setKey(k);
        this.version = version;
        this.accessTime = accessTime;
        this.maxIdleTime = maxIdleTime;
    }

    public void setKey(K k) {
        this.k = k;
    }

    @Override
    protected TouchCommand<K, V> createNewInstance() {
        return new TouchCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        super.selectReplicaInstance(this.k);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        ros.writeLong(this.version);
        ros.writeLong(this.accessTime);
        ros.writeLong(this.maxIdleTime);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.version = ris.readLong();
        this.accessTime = ris.readLong();
        this.maxIdleTime = ris.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, this.dsc.getInstanceName() + " received save " + this.k + " from " + initiator);
        }
        if ((entry = this.dsc.getReplicaStore().getEntry(this.k)) != null) {
            DataStoreEntry dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
            }
        }
    }
}

