/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.BroadcastLoadRequestCommand;
import org.shoal.adapter.store.commands.LoadRequestCommand;
import org.shoal.adapter.store.commands.RemoveCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.UpdateDeltaCommand;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryEvaluator;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationCommandTransmitterManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.DefaultKeyMapper;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedDataStore<K, V extends Serializable>
implements DataStore<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.config");
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreEntryHelper<K, V> transformer;
    private DataStoreContext<K, V> dsc;
    private DataStoreConfigurator<K, V> conf;
    private ReplicaStore<K, V> replicaStore;

    public ReplicatedDataStore(DataStoreConfigurator<K, V> conf, GroupService gs) {
        this.conf = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize(conf);
    }

    private void initialize(DataStoreConfigurator<K, V> conf) {
        KeyMapper keyMapper;
        this.dsc = new DataStoreContext(this.storeName, this.gs, conf.getClassLoader());
        this.transformer = conf.getDataStoreEntryHelper();
        this.dsc.setDataStoreEntryHelper(this.transformer);
        this.dsc.setDataStoreKeyHelper(conf.getDataStoreKeyHelper());
        this.dsc.setKeyMapper(conf.getKeyMapper());
        this.cm = this.dsc.getCommandManager();
        if (conf.getCommands() != null) {
            for (Command<K, V> cmd : conf.getCommands()) {
                this.cm.registerCommand(cmd);
            }
        }
        if (conf.isDoASyncReplication()) {
            this.cm.registerExecutionInterceptor(new ReplicationCommandTransmitterManager());
            this.cm.registerCommand(new ReplicationFramePayloadCommand());
            _logger.log(Level.INFO, "ASync replication enabled...");
        }
        if ((keyMapper = conf.getKeyMapper()) != null && keyMapper instanceof DefaultKeyMapper) {
            this.gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
        }
        this.gs.registerGroupMessageReceiver(this.storeName, this.cm);
        this.replicaStore = this.dsc.getReplicaStore();
        Logger logger = Logger.getLogger("org.shoal.ha.cache.config");
        logger.log(Level.INFO, "Created ReplicatedDataStore with config: " + conf);
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(K k, V v) throws DataStoreException {
        DataStoreEntry<K, V> entry;
        String result = null;
        DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(k);
        synchronized (dataStoreEntry) {
            SaveCommand<K, V> cmd;
            if (!entry.isRemoved()) {
                cmd = new SaveCommand<K, V>(k, v);
                this.cm.execute(cmd);
                if (this.conf.isCacheLocally()) {
                    entry.setV(v);
                }
            } else {
                return "";
            }
            entry.setReplicaInstanceName(cmd.getTargetName());
            result = cmd.getKeyMappingInfo();
        }
        return result;
    }

    @Override
    public String updateDelta(K k, V obj) throws DataStoreException {
        UpdateDeltaCommand<K, V> cmd = new UpdateDeltaCommand<K, V>(k, obj);
        this.cm.execute(cmd);
        return cmd.getKeyMappingInfo();
    }

    @Override
    public V get(K key) throws DataStoreException {
        return (V)this.get((Object)key, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, String cookie) throws DataStoreException {
        DataStoreEntry<K, Serializable> entry = this.replicaStore.getOrCreateEntry(key);
        Serializable v = null;
        DataStoreEntry<K, Serializable> dataStoreEntry = entry;
        synchronized (dataStoreEntry) {
            if (entry.isRemoved()) {
                return null;
            }
            v = (Serializable)entry.getV();
        }
        if (v == null) {
            Command cmd;
            String respondingInstanceName = null;
            if (cookie == null) {
                cmd = new BroadcastLoadRequestCommand(key);
                this.cm.execute(cmd);
                v = (Serializable)((BroadcastLoadRequestCommand)cmd).getResult(3L, TimeUnit.SECONDS);
                respondingInstanceName = ((BroadcastLoadRequestCommand)cmd).getRespondingInstanceName();
            } else {
                cmd = new LoadRequestCommand(key, cookie);
                this.cm.execute(cmd);
                v = (Serializable)((LoadRequestCommand)cmd).getResult(3L, TimeUnit.SECONDS);
                respondingInstanceName = ((LoadRequestCommand)cmd).getRespondingInstanceName();
            }
            DataStoreEntry<K, Serializable> dataStoreEntry2 = entry = this.replicaStore.getOrCreateEntry(key);
            synchronized (dataStoreEntry2) {
                if (!entry.isRemoved()) {
                    entry.setReplicaInstanceName(respondingInstanceName);
                    if (this.conf.isCacheLocally()) {
                        entry.setV(v);
                    }
                }
            }
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K k) throws DataStoreException {
        DataStoreEntry<K, V> entry;
        DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(k);
        synchronized (dataStoreEntry) {
            entry.markAsRemoved("Removed by ReplicatedDataStore.remove");
        }
        RemoveCommand cmd = new RemoveCommand();
        cmd.setKey(k);
        this.cm.execute(cmd);
    }

    @Override
    public String touch(K k, long version, long ts, long ttl) throws DataStoreException {
        return null;
    }

    @Override
    public int removeIdleEntries(long idleFor) {
        return 0;
    }

    @Override
    public Collection find(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
        return null;
    }

    @Override
    public void update(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
    }

    @Override
    public void close() {
    }
}

