/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.ObjectInputOutputStreamFactory;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class DefaultDataStoreEntryHelper<K, V>
implements DataStoreEntryHelper<K, V> {
    private ObjectInputOutputStreamFactory factory;
    private ClassLoader loader;
    private long defaultMaxIdleTime;

    public DefaultDataStoreEntryHelper(ObjectInputOutputStreamFactory factory, ClassLoader loader, long defaultMaxIdleTime) {
        this.factory = factory;
        this.loader = loader;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    @Override
    public V getV(DataStoreEntry<K, V> replicationEntry) throws DataStoreException {
        return replicationEntry == null ? null : (V)replicationEntry.getV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(ReplicationOutputStream ros, Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = this.factory.createObjectOutputStream(bos);
        try {
            oos.writeObject(obj);
            oos.flush();
            ros.writeLengthPrefixedBytes(bos.toByteArray());
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ioEx) {}
            try {
                bos.close();
            }
            catch (IOException ioEx) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(ReplicationInputStream ris) throws DataStoreException {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(ris.readLengthPrefixedBytes());
        ObjectInputStream ois = this.factory.createObjectInputStream(bis, this.loader);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                try {
                    bis.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ClassNotFoundException cnfEx) {
                throw new DataStoreException("Cannot desrialize value", cnfEx);
            }
            catch (IOException ioEx) {
                throw new DataStoreException("Cannot desrialize value", ioEx);
            }
        }
        try {
            ois.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        try {
            bis.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        return object;
    }
}

