/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="admin-object-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.admin.object")
public class AdminObjectManager
implements ResourceManager {
    @Inject
    private Applications applications;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ResourceUtil resourceUtil;
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AdminObjectManager.class);
    private String resType = null;
    private String className = null;
    private String raName = null;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;
    @Inject
    private ServerEnvironment environment;

    public String getResourceType() {
        return "admin-object-resource";
    }

    /*
     * Unable to fully structure code
     */
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target, boolean requiresNewTransaction, boolean createResourceRef, boolean requiresValidation) throws Exception {
        this.setAttributes(attributes, target);
        if (requiresValidation) {
            if (this.jndiName == null) {
                msg = AdminObjectManager.localStrings.getLocalString("create.admin.object.noJndiName", "No JNDI name defined for administered object.");
                return new ResourceStatus(1, msg);
            }
            if (resources.getResourceByName(BindableResource.class, this.jndiName) != null) {
                msg = AdminObjectManager.localStrings.getLocalString("create.admin.object.duplicate", "A resource named {0} already exists.", new Object[]{this.jndiName});
                return new ResourceStatus(1, msg);
            }
            if (this.environment.isDas()) {
                status = this.isValidRAName();
                if (status.getStatus() == 1) {
                    return status;
                }
                status = this.isValidAdminObject();
                if (status.getStatus() == 1) {
                    return status;
                }
            }
        }
        if (requiresNewTransaction) {
            try {
                ConfigSupport.apply(new SingleConfigCode<Resources>(){

                    @Override
                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return AdminObjectManager.this.createResource(param, properties);
                    }
                }, resources);
                if (!createResourceRef) ** GOTO lbl29
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
            catch (TransactionFailure tfe) {
                Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Unabled to create administered object", tfe);
                msg = AdminObjectManager.localStrings.getLocalString("create.admin.object.fail", "Unable to create administered object {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        } else {
            this.createResource(resources, properties);
        }
lbl29:
        // 3 sources

        msg = AdminObjectManager.localStrings.getLocalString("create.admin.object.success", "Administered object {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private AdminObjectResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        AdminObjectResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private AdminObjectResource createConfigBean(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        AdminObjectResource newResource = (AdminObjectResource)param.createChild(AdminObjectResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setResAdapter(this.raName);
        newResource.setResType(this.resType);
        newResource.setClassName(this.className);
        newResource.setEnabled(this.enabled);
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public void setAttributes(HashMap attributes, String target) {
        this.resType = (String)attributes.get("res-type");
        this.className = (String)attributes.get("class-name");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.raName = (String)attributes.get("res-adapter");
    }

    private ResourceStatus isValidAdminObject() {
        boolean isValidAdminObject = false;
        if (this.className == null) {
            String[] resTypes;
            try {
                resTypes = this.connectorRuntime.getAdminObjectInterfaceNames(this.raName);
            }
            catch (ConnectorRuntimeException cre) {
                Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Could not find admin-ojbect-interface names (resTypes) from ConnectorRuntime for resource adapter.", cre);
                String msg = localStrings.getLocalString("admin.mbeans.rmb.null_ao_intf", "Resource Adapter {0} does not contain any resource type for admin-object. Please specify another res-adapter.", new Object[]{this.raName}) + " " + cre.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
            if (resTypes == null || resTypes.length <= 0) {
                String msg = localStrings.getLocalString("admin.mbeans.rmb.null_ao_intf", "Resource Adapter {0} does not contain any resource type for admin-object. Please specify another res-adapter.", new Object[]{this.raName});
                return new ResourceStatus(1, msg);
            }
            int count = 0;
            for (int i = 0; i < resTypes.length; ++i) {
                if (!resTypes[i].equals(this.resType)) continue;
                isValidAdminObject = true;
                ++count;
            }
            if (count > 1) {
                String msg = localStrings.getLocalString("admin.mbeans.rmb.multiple_admin_objects.found.for.restype", "Need to specify admin-object classname parameter (--classname) as multiple admin objects use this resType [ {0} ]", new Object[]{this.resType});
                return new ResourceStatus(1, msg);
            }
        } else {
            try {
                isValidAdminObject = this.connectorRuntime.hasAdminObject(this.raName, this.resType, this.className);
            }
            catch (ConnectorRuntimeException cre) {
                Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Could not find admin-object-interface names (resTypes) and admin-object-classnames from ConnectorRuntime for resource adapter.", cre);
                String msg = localStrings.getLocalString("admin.mbeans.rmb.ao_intf_impl_check_failed", "Could not determine admin object resource information of Resource Adapter [ {0} ] forresType [ {1} ] and classname [ {2} ] ", new Object[]{this.raName, this.resType, this.className}) + " " + cre.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        }
        if (!isValidAdminObject) {
            String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_res_type", "Invalid Resource Type: {0}", new Object[]{this.resType});
            return new ResourceStatus(1, msg);
        }
        return new ResourceStatus(0, "");
    }

    private ResourceStatus isValidRAName() {
        ResourceStatus status = new ResourceStatus(0, "");
        if (this.raName == null || this.raName.equals("")) {
            String msg = localStrings.getLocalString("admin.mbeans.rmb.null_res_adapter", "Resource Adapter Name is null.");
            status = new ResourceStatus(1, msg);
        } else if (!this.raName.equals("jmsra") && !this.raName.equals("jaxr-ra")) {
            int indx = this.raName.indexOf("#");
            if (indx != -1) {
                String appName = this.raName.substring(0, indx);
                Application app = (Application)this.applications.getModule(Application.class, appName);
                if (app == null) {
                    String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_ra_app_not_found", "Invalid raname. Application with name {0} not found.", new Object[]{appName});
                    status = new ResourceStatus(1, msg);
                }
            } else {
                Application app = (Application)this.applications.getModule(Application.class, this.raName);
                if (app == null) {
                    String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_ra_cm_not_found", "Invalid raname. Connector Module with name {0} not found.", new Object[]{this.raName});
                    status = new ResourceStatus(1, msg);
                }
            }
        }
        return status;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes, null);
        return this.createConfigBean(resources, properties);
    }
}

