/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.resource")
public class ConnectorResourceManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorResourceManager.class);
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;
    private String objectType = "user";
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;
    @Inject
    private ResourceUtil resourceUtil;

    public String getResourceType() {
        return "connector-resource";
    }

    /*
     * Unable to fully structure code
     */
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target, boolean requiresNewTransaction, boolean createResourceRef, boolean requiresValidation) throws Exception {
        this.setAttributes(attributes, target);
        if (requiresValidation) {
            if (this.jndiName == null) {
                msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.noJndiName", "No JNDI name defined for connector resource.");
                return new ResourceStatus(1, msg);
            }
            if (resources.getResourceByName(BindableResource.class, this.jndiName) != null) {
                msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.duplicate", "A resource named {0} already exists. In order to make the resource available in instances/clusters, use create-resource-ref", new Object[]{this.jndiName});
                return new ResourceStatus(1, msg);
            }
            if (!this.isConnPoolExists(resources, this.poolName)) {
                msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of connector connection pools.", new Object[]{this.poolName});
                return new ResourceStatus(1, msg);
            }
        }
        if (requiresNewTransaction) {
            try {
                ConfigSupport.apply(new SingleConfigCode<Resources>(){

                    @Override
                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return ConnectorResourceManager.this.createResource(param, properties);
                    }
                }, resources);
                if (!createResourceRef) ** GOTO lbl24
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
            catch (TransactionFailure tfe) {
                msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.fail", "Connector resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        } else {
            this.createResource(resources, properties);
        }
lbl24:
        // 3 sources

        msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.success", "Connector resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ConnectorResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private ConnectorResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = (ConnectorResource)param.createChild(ConnectorResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setPoolName(this.poolName);
        newResource.setEnabled(this.enabled);
        newResource.setObjectType(this.objectType);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.objectType = (String)attributes.get("object-type");
    }

    private boolean isConnPoolExists(Resources resources, String poolName) {
        return resources.getResourceByName(ConnectorConnectionPool.class, poolName) != null;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes, null);
        return this.createConfigBean(resources, properties);
    }
}

