/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.sftp;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SFTPClient
extends SFTPv3Client {
    public SFTPClient(Connection conn) throws IOException {
        super(conn);
    }

    public boolean exists(String path) throws IOException {
        return this._stat(path) != null;
    }

    public SFTPv3FileAttributes _stat(String path) throws IOException {
        try {
            return this.stat(path);
        }
        catch (SFTPException e) {
            int c = e.getServerErrorCode();
            if (c == 2 || c == 10) {
                return null;
            }
            throw e;
        }
    }

    public void mkdirs(String path, int posixPermission) throws IOException {
        SFTPv3FileAttributes atts = this._stat(path);
        if (atts != null && atts.isDirectory()) {
            return;
        }
        int idx = path.lastIndexOf("/");
        if (idx > 0) {
            this.mkdirs(path.substring(0, idx), posixPermission);
        }
        try {
            this.mkdir(path, posixPermission);
        }
        catch (IOException e) {
            throw new IOException("Failed to mkdir " + path, e);
        }
    }

    public OutputStream writeToFile(String path) throws IOException {
        final SFTPv3FileHandle h = this.createFile(path);
        return new OutputStream(){
            private long offset = 0L;

            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            public void write(byte[] b, int off, int len) throws IOException {
                SFTPClient.this.write(h, this.offset, b, off, len);
                this.offset += (long)len;
            }

            public void close() throws IOException {
                SFTPClient.this.closeFile(h);
            }
        };
    }

    public InputStream read(String file) throws IOException {
        final SFTPv3FileHandle h = this.openFileRO(file);
        return new InputStream(){
            private long offset = 0L;

            public int read() throws IOException {
                byte[] b = new byte[1];
                if (this.read(b) < 0) {
                    return -1;
                }
                return b[0];
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int r = SFTPClient.this.read(h, this.offset, b, off, len);
                if (r < 0) {
                    return -1;
                }
                this.offset += (long)r;
                return r;
            }

            public long skip(long n) throws IOException {
                this.offset += n;
                return n;
            }

            public void close() throws IOException {
                SFTPClient.this.closeFile(h);
            }
        };
    }

    public void chmod(String path, int permissions) throws IOException {
        SFTPv3FileAttributes atts = new SFTPv3FileAttributes();
        atts.permissions = permissions;
        this.setstat(path, atts);
    }
}

