/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.WebModuleReaderImpl;
import org.glassfish.loadbalancer.admin.cli.reader.impl.WebServiceEndpointReaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterReaderHelper {
    public static WebModuleReader[] getWebModules(Domain domain, ApplicationRegistry appRegistry, List<ApplicationRef> refs, String target) {
        ArrayList<WebModuleReader> list = new ArrayList<WebModuleReader>();
        Iterator<ApplicationRef> refAppsIter = refs.iterator();
        HashMap<String, ApplicationRef> refferedApps = new HashMap<String, ApplicationRef>();
        while (refAppsIter.hasNext()) {
            ApplicationRef appRef = refAppsIter.next();
            refferedApps.put(appRef.getRef(), appRef);
        }
        Applications applications = domain.getApplications();
        HashSet apps = new HashSet();
        apps.addAll(applications.getApplicationsWithSnifferType("web"));
        apps.addAll(applications.getApplicationsWithSnifferType("webservices"));
        for (Application app : apps) {
            String appName = app.getName();
            if (!refferedApps.containsKey(appName)) continue;
            ApplicationInfo appInfo = appRegistry.get(appName);
            if (appInfo == null) {
                System.out.println("Unable to get appInfo for application " + appName);
                continue;
            }
            com.sun.enterprise.deployment.Application depApp = (com.sun.enterprise.deployment.Application)appInfo.getMetaData(com.sun.enterprise.deployment.Application.class);
            for (BundleDescriptor bundleDescriptor : depApp.getBundleDescriptors()) {
                EjbBundleDescriptor ejbBundleDescriptor;
                if (bundleDescriptor instanceof WebBundleDescriptor) {
                    WebModuleReaderImpl wmr = new WebModuleReaderImpl(appName, (ApplicationRef)refferedApps.get(appName), app, (WebBundleDescriptor)bundleDescriptor);
                    list.add(wmr);
                    continue;
                }
                if (!(bundleDescriptor instanceof EjbBundleDescriptor) || !(ejbBundleDescriptor = (EjbBundleDescriptor)bundleDescriptor).hasWebServices()) continue;
                Iterator wsIter = ejbBundleDescriptor.getWebServices().getEndpoints().iterator();
                while (wsIter.hasNext()) {
                    WebServiceEndpointReaderImpl wsr = new WebServiceEndpointReaderImpl(appName, (ApplicationRef)refferedApps.get(appName), app, (WebServiceEndpoint)wsIter.next());
                    list.add(wsr);
                }
            }
        }
        WebModuleReader[] webModules = new WebModuleReader[list.size()];
        return list.toArray(webModules);
    }
}

