/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResult;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class GetResultHtmlProvider
extends BaseProvider<GetResult> {
    public GetResultHtmlProvider() {
        super(GetResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public String getContent(GetResult proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getAbsolutePath().toString(), '/')));
        result = result + "<h1>" + typeKey + "</h1>";
        String attributes = ProviderUtil.getHtmlRepresentationForAttributes((ConfigBean)proxy.getDom(), this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(attributes, "Attributes", result);
        String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("DELETE"), "DELETE", "Delete", this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + typeKey, result);
        String childResourceLinks = this.getResourcesLinks(proxy);
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", result);
        String commandLinks = this.getCommandLinks(proxy.getCommandResourcesPaths());
        result = ProviderUtil.getHtmlForComponent(commandLinks, "Commands", result);
        result = result + "</body></html>";
        return result;
    }

    private String getResourcesLinks(GetResult getResult) {
        StringBuilder links = new StringBuilder("<div>");
        for (Map.Entry<String, String> link : this.getResourceLinks(getResult.getDom()).entrySet()) {
            links.append("<a href=\"").append(link.getValue()).append("\">").append(link.getKey()).append("</a><br>");
        }
        return links.append("</div><br>").toString();
    }

    private String getCommandLinks(String[][] commandResourcesPaths) {
        StringBuilder result = new StringBuilder("<div>");
        for (String[] commandResourcePath : commandResourcesPaths) {
            if (commandResourcePath[2].startsWith("_")) {
                result.append("<!--");
            }
            result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0])).append("\">").append(commandResourcePath[0]).append("</a><br>");
            if (!commandResourcePath[2].startsWith("_")) continue;
            result.append("-->");
        }
        return result.append("</div><br>").toString();
    }
}

