/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.io.Serializable;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.weld.conversation.ConversationInactivityTimeout;
import org.jboss.weld.conversation.ConversationManager2;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

@RequestScoped
@Named(value="javax.enterprise.context.conversation")
@Default
public class ConversationImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    @Inject
    private ConversationManager2 conversationManager;
    private String id;
    private boolean _transient = true;
    private long timeout;
    private String resumedId;

    public ConversationImpl() {
    }

    private void checkForActiveConversationContext(String when) {
        if (!this.conversationManager.isContextActive()) {
            throw new ContextNotActiveException("Conversation context not active when calling " + when + " on " + this);
        }
    }

    protected ConversationImpl(Conversation conversation, ConversationManager2 conversationManager) {
        this.id = conversation.getId();
        this._transient = conversation.isTransient();
        this.timeout = conversation.getTimeout();
        this.conversationManager = conversationManager;
    }

    public static ConversationImpl of(Conversation conversation, ConversationManager2 conversationManager) {
        return new ConversationImpl(conversation, conversationManager);
    }

    @Inject
    public void init(@ConversationInactivityTimeout long timeout) {
        if (this.timeout == 0L) {
            this.timeout = timeout;
        }
        this._transient = true;
    }

    public void begin() {
        this.checkForActiveConversationContext("Conversation.begin()");
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        log.debug(ConversationMessage.PROMOTED_TRANSIENT, this.id);
        this._transient = false;
        this.id = this.conversationManager.generateConversationId();
    }

    public void begin(String id) {
        this.checkForActiveConversationContext("Conversation.begin(String)");
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        if (this.conversationManager.getConversations().containsKey(id)) {
            throw new IllegalStateException(ConversationMessage.CONVERSATION_ID_ALREADY_IN_USE, id);
        }
        this._transient = false;
        this.id = id;
    }

    public void end() {
        this.checkForActiveConversationContext("Conversation.end()");
        if (this._transient) {
            throw new IllegalStateException(ConversationMessage.END_CALLED_ON_TRANSIENT_CONVERSATION, new Object[0]);
        }
        log.debug(ConversationMessage.DEMOTED_LRC, this.id);
        this._transient = true;
        this.id = null;
    }

    public String getId() {
        this.checkForActiveConversationContext("Conversation.getId()");
        return this.id;
    }

    public long getTimeout() {
        this.checkForActiveConversationContext("Conversation.getTimeout()");
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.checkForActiveConversationContext("Conversation.setTimeout()");
        this.timeout = timeout;
    }

    public void switchTo(Conversation conversation) {
        log.debug(ConversationMessage.SWITCHED_CONVERSATION, this, conversation);
        this.id = conversation.getId();
        this._transient = conversation.isTransient();
        this.timeout = conversation.getTimeout();
        this.resumedId = this.id;
    }

    public String toString() {
        return "ID: " + this.id + ", transient: " + this._transient + ", timeout: " + this.timeout + "ms";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConversationImpl) {
            ConversationImpl that = (ConversationImpl)obj;
            return this.id == null || that.getId() == null ? false : this.id.equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? super.hashCode() : this.id.hashCode();
    }

    public boolean isTransient() {
        this.checkForActiveConversationContext("Conversation.isTransient()");
        return this._transient;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResumedId() {
        return this.resumedId;
    }

    public ConversationImpl unProxy(ConversationManager2 conversationManager) {
        return new ConversationImpl(this, conversationManager);
    }
}

