/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.inject.Provider;
import org.jboss.weld.Container;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.literal.NewLiteral;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.logging.messages.ResolutionMessage;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableBuilder {
    protected Class<?> rawType;
    protected final Set<Type> types = new HashSet<Type>();
    protected final Set<Annotation> qualifiers = new HashSet<Annotation>();
    protected final Map<Class<? extends Annotation>, Annotation> mappedQualifiers = new HashMap<Class<? extends Annotation>, Annotation>();
    protected Bean<?> declaringBean;

    public ResolvableBuilder() {
    }

    public ResolvableBuilder(Type type) {
        this();
        if (type != null) {
            this.rawType = Reflections.getRawType(type);
            if (this.rawType == null) {
                throw new IllegalArgumentException(ResolutionMessage.CANNOT_EXTRACT_RAW_TYPE, type);
            }
            this.types.add(type);
        }
    }

    public ResolvableBuilder(InjectionPoint injectionPoint) {
        this(injectionPoint.getType());
        Named named;
        this.addQualifiers(injectionPoint.getQualifiers());
        if (this.mappedQualifiers.containsKey(Named.class) && injectionPoint.getMember() instanceof Field && (named = (Named)this.mappedQualifiers.get(Named.class)).value().equals("")) {
            this.qualifiers.remove(named);
            named = new NamedLiteral(injectionPoint.getMember().getName());
            this.qualifiers.add(named);
            this.mappedQualifiers.put(Named.class, named);
        }
        this.setDeclaringBean(injectionPoint.getBean());
    }

    public ResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        this.declaringBean = declaringBean;
        return this;
    }

    public ResolvableBuilder addType(Type type) {
        this.types.add(type);
        return this;
    }

    public ResolvableBuilder addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public Resolvable create() {
        if (this.qualifiers.size() == 0) {
            this.qualifiers.add(DefaultLiteral.INSTANCE);
        }
        if (Reflections.isAssignableFrom(Event.class, this.types)) {
            return this.createFacade(Event.class);
        }
        if (Reflections.isAssignableFrom(Instance.class, this.types)) {
            return this.createFacade(Instance.class);
        }
        if (Reflections.isAssignableFrom(Provider.class, this.types)) {
            return this.createFacade(Provider.class);
        }
        return new ResolvableImpl(this.rawType, this.types, this.qualifiers, this.mappedQualifiers, this.declaringBean);
    }

    private Resolvable createFacade(Class<?> rawType) {
        Set<Annotation> qualifiers = Collections.singleton(AnyLiteral.INSTANCE);
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, qualifiers, this.mappedQualifiers, this.declaringBean);
    }

    public ResolvableBuilder addQualifier(Annotation qualifier) {
        if (qualifier.annotationType().equals(New.class)) {
            New newQualifier = (New)New.class.cast(qualifier);
            if (newQualifier.value().equals(New.class) && this.rawType == null) {
                throw new IllegalStateException("Cannot transform @New when there is no known raw type");
            }
            if (newQualifier.value().equals(New.class)) {
                qualifier = new NewLiteral(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Class<?> value() {
                        return ResolvableBuilder.this.rawType;
                    }
                };
            }
        }
        this.checkQualifier(qualifier);
        this.qualifiers.add(qualifier);
        this.mappedQualifiers.put(qualifier.annotationType(), qualifier);
        return this;
    }

    public ResolvableBuilder addQualifierIfAbsent(Annotation qualifier) {
        if (!this.qualifiers.contains(qualifier)) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    protected void checkQualifier(Annotation qualifier) {
        if (!Container.instance().services().get(MetaAnnotationStore.class).getBindingTypeModel(qualifier.annotationType()).isValid()) {
            throw new IllegalArgumentException(BeanManagerMessage.INVALID_QUALIFIER, qualifier);
        }
        if (this.qualifiers.contains(qualifier)) {
            throw new IllegalArgumentException(BeanManagerMessage.DUPLICATE_QUALIFIERS, Arrays.asList(this.qualifiers));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ResolvableImpl
    implements Resolvable {
        private final Set<Annotation> qualifiers;
        private final Map<Class<? extends Annotation>, Annotation> mappedQualifiers;
        private final Set<Type> typeClosure;
        private final Class<?> rawType;
        private final Bean<?> declaringBean;

        protected ResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Set<Annotation> qualifiers, Map<Class<? extends Annotation>, Annotation> mappedQualifiers, Bean<?> declaringBean) {
            this.qualifiers = qualifiers;
            this.mappedQualifiers = mappedQualifiers;
            this.typeClosure = typeClosure;
            this.rawType = rawType;
            this.declaringBean = declaringBean;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.mappedQualifiers.containsKey(annotationType);
        }

        @Override
        public Set<Type> getTypes() {
            return this.typeClosure;
        }

        @Override
        public boolean isAssignableTo(Class<?> clazz) {
            return Reflections.isAssignableFrom(clazz, this.typeClosure);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.mappedQualifiers.get(annotationType);
        }

        @Override
        public Class<?> getJavaClass() {
            return this.rawType;
        }

        @Override
        public Bean<?> getDeclaringBean() {
            return this.declaringBean;
        }

        public String toString() {
            return "Types: " + this.getTypes() + "; Bindings: " + this.getQualifiers();
        }

        @Override
        public int getHashCode() {
            int result = 17;
            result = 31 * result + ((Object)this.getTypes()).hashCode();
            result = 31 * result + ((Object)this.getQualifiers()).hashCode();
            return result;
        }

        @Override
        public boolean isEqualTo(Resolvable r) {
            return ((Object)this.getTypes()).equals(r.getTypes()) && ((Object)this.getQualifiers()).equals(r.getQualifiers());
        }
    }
}

