/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeInterceptorResolver
extends TypeSafeResolver<InterceptorResolvable, Interceptor<?>> {
    private final BeanManagerImpl manager;

    public TypeSafeInterceptorResolver(BeanManagerImpl manager, Iterable<Interceptor<?>> interceptors) {
        super(interceptors);
        this.manager = manager;
    }

    @Override
    protected boolean matches(InterceptorResolvable resolvable, Interceptor<?> bean) {
        return bean.intercepts(resolvable.getInterceptionType()) && bean.getInterceptorBindings().size() > 0 && Beans.containsAllInterceptionBindings(bean.getInterceptorBindings(), resolvable.getQualifiers(), this.getManager()) && this.getManager().getEnabledClasses().getInterceptors().contains(bean.getBeanClass());
    }

    @Override
    protected Set<Interceptor<?>> sortResult(Set<Interceptor<?>> matchedInterceptors) {
        TreeSet sortedBeans = new TreeSet(new Comparator<Interceptor<?>>(){

            @Override
            public int compare(Interceptor<?> o1, Interceptor<?> o2) {
                int p1 = TypeSafeInterceptorResolver.this.getManager().getEnabledClasses().getInterceptors().indexOf(((InterceptorImpl)o1).getType());
                int p2 = TypeSafeInterceptorResolver.this.getManager().getEnabledClasses().getInterceptors().indexOf(((InterceptorImpl)o2).getType());
                return p1 - p2;
            }
        });
        sortedBeans.addAll(matchedInterceptors);
        return sortedBeans;
    }

    @Override
    protected Set<Interceptor<?>> filterResult(Set<Interceptor<?>> matched) {
        return matched;
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }
}

