/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class ReadQuery
extends DatabaseQuery {
    protected int maxRows = 0;
    protected int firstResult = 0;
    protected long queryId = 0L;
    protected int fetchSize = 0;
    protected QueryResultsCachePolicy queryResultCachingPolicy = null;
    protected transient Object temporaryCachedQueryResults = null;

    public Object buildObject(AbstractRecord row) {
        return row;
    }

    public void cacheQueryResults() {
        this.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
    }

    public abstract void cacheResult(Object var1);

    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
        Object result;
        if (this.shouldCacheQueryResults() && (result = ((ReadQuery)query).getTemporaryCachedQueryResults()) != null) {
            this.setQueryResults(result, query.getTranslationRow(), query.getSession());
        }
    }

    public void clearQueryResults(AbstractSession session) {
        session.getIdentityMapAccessor().clearQueryCache(this);
    }

    public void doNotCacheQueryResults() {
        this.setQueryResultsCachePolicy(null);
    }

    public QueryResultsCachePolicy getQueryResultsCachePolicy() {
        return this.queryResultCachingPolicy;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected Object getQueryResults(AbstractSession session) {
        return this.getQueryResults(session, this.getTranslationRow(), true);
    }

    protected Object getQueryResults(AbstractSession session, boolean checkExpiry) {
        return this.getQueryResults(session, this.getTranslationRow(), checkExpiry);
    }

    protected Object getQueryResults(AbstractSession session, AbstractRecord row, boolean checkExpiry) {
        Vector arguments = null;
        if (row != null) {
            arguments = row.getValues();
        }
        return session.getIdentityMapAccessorInstance().getQueryResult(this, arguments, checkExpiry);
    }

    public Object getTemporaryCachedQueryResults() {
        return this.temporaryCachedQueryResults;
    }

    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && this.getMaxRows() == 0 && this.getFirstResult() == 0 && this.getFetchSize() == 0;
    }

    public boolean isReadQuery() {
        return true;
    }

    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)query;
            this.fetchSize = readQuery.fetchSize;
            this.firstResult = readQuery.firstResult;
            this.maxRows = readQuery.maxRows;
            this.queryResultCachingPolicy = readQuery.queryResultCachingPolicy;
        }
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.shouldCacheQueryResults()) {
            this.clearQueryResults(this.getSession());
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        DatabaseCall databaseCall = this.getCall();
        if (databaseCall != null && (databaseCall.shouldIgnoreFirstRowSetting() || databaseCall.shouldIgnoreMaxResultsSetting())) {
            AbstractRecord parameters = this.getTranslationRow();
            if (parameters.isEmpty()) {
                parameters = new DatabaseRecord();
            }
            parameters.add(DatabaseCall.FIRSTRESULT_FIELD, this.getFirstResult());
            parameters.add(DatabaseCall.MAXROW_FIELD, this.session.getPlatform().computeMaxRowsForSQL(this.getFirstResult(), this.getMaxRows()));
            this.setTranslationRow(parameters);
        }
    }

    public Object remoteExecute(AbstractSession session) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object queryResults;
            AbstractRecord arguments = new DatabaseRecord();
            if (this.translationRow != null) {
                arguments = this.translationRow;
            }
            if ((queryResults = this.getQueryResults(session, arguments, true)) != null) {
                return queryResults;
            }
            queryResults = super.remoteExecute(session);
            if (queryResults != null) {
                this.setQueryResults(queryResults, arguments, session);
            }
            return queryResults;
        }
        return super.remoteExecute(session);
    }

    public void setQueryResultsCachePolicy(QueryResultsCachePolicy policy) {
        this.queryResultCachingPolicy = policy;
        this.setIsPrepared(false);
    }

    public void setFirstResult(int firstResult) {
        if (this.isPrepared() && this.firstResult != firstResult && (this.getCall() == null || !this.getCall().shouldIgnoreFirstRowSetting())) {
            this.setIsPrepared(false);
        }
        this.firstResult = firstResult;
        this.shouldCloneCall = true;
    }

    public void setQueryId(long id) {
        this.queryId = id;
    }

    public void setMaxRows(int maxRows) {
        if (this.isPrepared() && this.maxRows != maxRows && (this.getCall() == null || !this.getCall().shouldIgnoreMaxResultsSetting() || this.maxRows <= 0)) {
            this.setIsPrepared(false);
        }
        this.maxRows = maxRows;
        this.shouldCloneCall = true;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected void setQueryResults(Object resultFromQuery, AbstractRecord row, AbstractSession session) {
        Vector arguments = null;
        arguments = row == null ? new NonSynchronizedVector(1) : row.getValues();
        session.getIdentityMapAccessorInstance().putQueryResult(this, arguments, resultFromQuery);
    }

    public boolean shouldCacheQueryResults() {
        return this.queryResultCachingPolicy != null;
    }

    public void setTemporaryCachedQueryResults(Object queryResults) {
        this.temporaryCachedQueryResults = queryResults;
    }
}

