/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jca.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class ConnectorsHandlers {
    public static final String ADMINOBJECT_INTERFACES_KEY = "AdminObjectInterfacesKey";
    public static final String ADMINOBJECT_CLASSES_KEY = "AdminObjectClassesKey";
    public static final String CONNECTION_DEFINITION_NAMES_KEY = "ConnectionDefinitionNamesKey";
    public static final String MCF_CONFIG_PROPS_KEY = "McfConfigPropsKey";
    public static final String SYSTEM_CONNECTORS_KEY = "SystemConnectorsKey";
    public static final String ADMINOBJECT_CONFIG_PROPS_KEY = "AdminObjectConfigPropsKey";
    public static final String RESOURCE_ADAPTER_CONFIG_PROPS_KEY = "ResourceAdapterConfigPropsKey";

    public static void getConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        Boolean fromStep1 = (Boolean)handlerCtx.getInputValue("fromStep1");
        if (fromStep2 != null && fromStep2.booleanValue()) {
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            String resAdapter = (String)extra.get("ResourceAdapterName");
            handlerCtx.setOutputValue("resultAdapter", (Object)resAdapter);
        } else if (fromStep1 != null && fromStep1.booleanValue()) {
            String poolName;
            String resAdapter = (String)handlerCtx.getInputValue("resAdapter");
            if (resAdapter != null) {
                resAdapter = resAdapter.trim();
            }
            if ((poolName = (String)handlerCtx.getInputValue("poolName")) != null) {
                poolName = poolName.trim();
            }
            if (resAdapter != null && !resAdapter.equals("")) {
                Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
                extra.put("ResourceAdapterName", resAdapter);
                extra.put("Name", poolName);
                handlerCtx.setOutputValue("resultAdapter", (Object)resAdapter);
            }
        } else {
            HashMap extra = new HashMap();
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardMap", attrMap);
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolExtra", extra);
        }
    }

    public static void updateConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Map props = (Map)handlerCtx.getInputValue("props");
        if (props != null) {
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap((Map)props));
        } else {
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", new ArrayList());
        }
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        extra.put("previousDefinition", (String)handlerCtx.getInputValue("currentDef"));
        extra.put("previousResAdapter", (String)handlerCtx.getInputValue("currentAdapter"));
    }

    public static void updateConnectorConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMap");
        String resAdapter = (String)extra.get("ResourceAdapterName");
        String definition = (String)extra.get("ConnectionDefinitionName");
        String name = (String)extra.get("Name");
        attrs.put("Name", name);
        attrs.put("ConnectionDefinitionName", definition);
        attrs.put("ResourceAdapterName", resAdapter);
    }

    public static void convertSecurityMapPropsToStringArray(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("usersOptions");
        String edit = (String)handlerCtx.getInputValue("edit");
        String userGroups = (String)handlerCtx.getInputValue("userGroups");
        String principals = (String)handlerCtx.getInputValue("principals");
        String value = null;
        String[] str = null;
        String[] emptyVal = null;
        boolean usePrincipals = false;
        if (option != null) {
            value = userGroups;
            usePrincipals = false;
        } else {
            value = principals;
            usePrincipals = true;
        }
        str = value != null && value.indexOf(",") != -1 ? GuiUtil.stringToArray((String)value, (String)",") : new String[]{value};
        if (edit.equals("true")) {
            emptyVal = new String[]{};
        }
        handlerCtx.setOutputValue("principalsSA", (Object)(usePrincipals ? str : emptyVal));
        handlerCtx.setOutputValue("usersSA", (Object)(usePrincipals ? emptyVal : str));
    }

    public static void getAdminObjectResourceWizard(HandlerContext handlerCtx) {
        Boolean reload = (Boolean)handlerCtx.getInputValue("reload");
        HashMap<String, String> attrMap = (HashMap<String, String>)handlerCtx.getInputValue("attrMap");
        Map currentMap = (Map)handlerCtx.getInputValue("currentMap");
        String name = null;
        String resAdapter = null;
        String resType = null;
        String className = null;
        if (attrMap == null) {
            attrMap = new HashMap<String, String>();
        }
        if (!(reload != null && reload.booleanValue() || currentMap == null)) {
            name = (String)currentMap.get("name");
            resAdapter = (String)currentMap.get("resAdapter");
            resType = (String)currentMap.get("resType");
            className = (String)currentMap.get("className");
            attrMap.putAll(currentMap);
        } else if (attrMap != null) {
            name = (String)attrMap.get("name");
            resAdapter = (String)attrMap.get("resAdapter");
            resType = (String)attrMap.get("resType");
            className = (String)attrMap.get("className");
        }
        if (resAdapter != null) {
            resAdapter = resAdapter.trim();
        }
        if (resAdapter == null || resAdapter.equals("")) {
            resAdapter = "jmsra";
        }
        attrMap.put("name", name);
        attrMap.put("resType", resType);
        attrMap.put("resAdapter", resAdapter);
        attrMap.put("className", className);
        handlerCtx.setOutputValue("valueMap", attrMap);
    }

    public static void createWorkSecurityMap(HandlerContext handlerCtx) {
        String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
        String childType = (String)handlerCtx.getInputValue("childType");
        String usersOptionG = (String)handlerCtx.getInputValue("usersOptionG");
        String usersOptionP = (String)handlerCtx.getInputValue("usersOptionP");
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        Map mappings = (Map)handlerCtx.getInputValue("mapping");
        try {
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxy(new ObjectName(parentObjectNameStr));
            List convertToFalse = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalse != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.put(sk, "false");
                }
            }
            V3AMX.removeElement((Map)attrs);
            Set attrSet = attrs.entrySet();
            Iterator iter = attrSet.iterator();
            while (iter.hasNext()) {
                Map.Entry oneEntry = iter.next();
                Object val = oneEntry.getValue();
                if (val == null || !(val instanceof String) || !val.equals("")) continue;
                iter.remove();
            }
            AMXConfigProxy workSecurityMap = amx.createChild(childType, attrs);
            ConnectorsHandlers.setWorkSecurityMapChildren(workSecurityMap, usersOptionG, usersOptionP, mappings);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("createWorkSecurityMap error");
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static void setWorkSecurityMapChildren(AMXConfigProxy amx, String usersOptionG, String usersOptionP, Map mappings) {
        Map mappingAttrs = new HashMap();
        if (usersOptionG != null && usersOptionG.equals("users")) {
            String groupsMapping = (String)mappings.get("GroupMapping");
            mappingAttrs = ConnectorsHandlers.stringToMap(groupsMapping, ",");
            for (String key : mappingAttrs.keySet()) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("EisGroup", key);
                attrs.put("MappedGroup", (String)mappingAttrs.get(key));
                amx.createChild("group-map", attrs);
            }
        } else {
            String principalMapping = (String)mappings.get("PrincipalMapping");
            mappingAttrs = ConnectorsHandlers.stringToMap(principalMapping, ",");
            for (String key : mappingAttrs.keySet()) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("EisPrincipal", key);
                attrs.put("MappedPrincipal", (String)mappingAttrs.get(key));
                amx.createChild("principal-map", attrs);
            }
        }
    }

    public static void saveWorkSecurityMap(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        Map valueMap = (Map)handlerCtx.getInputValue("valueMap");
        Map valueMap2 = (Map)handlerCtx.getInputValue("valueMap2");
        String usersOptionG = (String)handlerCtx.getInputValue("usersOptionG");
        String usersOptionP = (String)handlerCtx.getInputValue("usersOptionP");
        try {
            Map pchildren;
            AttributeList attrList = new AttributeList();
            Attribute rarAttr = new Attribute("ResourceAdapterName", valueMap.get("ResourceAdapterName"));
            String desc = valueMap.get("Description") == null ? null : (String)valueMap.get("Description");
            Attribute descAttr = new Attribute("Description", desc);
            String enable = valueMap.get("Enabled") == null ? "false" : (String)valueMap.get("Enabled");
            Attribute enableAttr = new Attribute("Enabled", enable);
            attrList.add(rarAttr);
            attrList.add(descAttr);
            attrList.add(enableAttr);
            V3AMX.setAttributes((ObjectName)new ObjectName(objectNameStr), (AttributeList)attrList);
            AMXConfigProxy workSecurityMap = (AMXConfigProxy)V3AMX.getInstance().getProxy(new ObjectName(objectNameStr));
            Map children = workSecurityMap.childrenMap("group-map");
            if (children.size() > 0) {
                for (String oneChild : children.keySet()) {
                    workSecurityMap.removeChild("group-map", oneChild);
                }
            }
            if ((pchildren = workSecurityMap.childrenMap("principal-map")).size() > 0) {
                for (String oneChild : pchildren.keySet()) {
                    workSecurityMap.removeChild("principal-map", oneChild);
                }
            }
            ConnectorsHandlers.setWorkSecurityMapChildren(workSecurityMap, usersOptionG, usersOptionP, valueMap2);
        }
        catch (Exception ex) {
            GuiUtil.prepareException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getWorkSecurityMap(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            HashMap<String, String> valueMap2 = new HashMap<String, String>();
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxy(new ObjectName(objectNameStr));
            Map children = amx.childrenMap("group-map");
            if (children.size() > 0) {
                String gp = "";
                for (AMXProxy oneGroup : children.values()) {
                    ObjectName objN = oneGroup.objectName();
                    gp = gp + V3AMX.getAttribute((Object)objN, (String)"EisGroup") + "=" + V3AMX.getAttribute((Object)objN, (String)"MappedGroup");
                    gp = gp + ",";
                }
                gp = gp.substring(0, gp.length() - 1);
                valueMap2.put("GroupMapping", gp);
                handlerCtx.setOutputValue("usersOptionG", (Object)"users");
            } else {
                Map pChildren = amx.childrenMap("principal-map");
                if (pChildren.size() > 0) {
                    String pM = "";
                    for (AMXProxy oneGroup : pChildren.values()) {
                        ObjectName objN = oneGroup.objectName();
                        pM = pM + V3AMX.getAttribute((Object)objN, (String)"EisPrincipal") + "=" + V3AMX.getAttribute((Object)objN, (String)"MappedPrincipal");
                        pM = pM + ",";
                    }
                    pM = pM.substring(0, pM.length() - 1);
                    valueMap2.put("PrincipalMapping", pM);
                    handlerCtx.setOutputValue("usersOptionP", (Object)"principals");
                }
            }
            handlerCtx.setOutputValue("valueMap2", valueMap2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getResourceAdapterConfigNewInfo(HandlerContext handlerCtx) {
        String rarName = (String)handlerCtx.getInputValue("name");
        if (GuiUtil.isEmpty((String)rarName)) {
            rarName = "jmsra";
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("name", rarName);
        handlerCtx.setOutputValue("valueMap", valueMap);
        Map result = V3AMX.getInstance().getConnectorRuntime().getResourceAdapterConfigProps(rarName);
        if (result != null) {
            Map props = (Map)result.get(RESOURCE_ADAPTER_CONFIG_PROPS_KEY);
            handlerCtx.setOutputValue("tableList", (Object)GuiUtil.convertMapToListOfMap((Map)props));
        } else {
            ArrayList noprops = new ArrayList();
            handlerCtx.setOutputValue("tableList", noprops);
        }
    }

    public static void filterOutRarExtension(HandlerContext handlerCtx) {
        List inList = (List)handlerCtx.getInputValue("inList");
        ArrayList<String> convertedList = new ArrayList<String>();
        for (String one : inList) {
            if (one.indexOf("#") != -1 && one.endsWith(".rar")) {
                convertedList.add(one.substring(0, one.length() - 4));
                continue;
            }
            convertedList.add(one);
        }
        handlerCtx.setOutputValue("convertedList", convertedList);
    }

    public static Map stringToMap(String str, String delimiter) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (str != null && delimiter != null) {
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                String[] values = token.split("=");
                if (values.length != 2) continue;
                props.put(values[0], values[1]);
            }
        }
        return props;
    }
}

