<!--

    DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

    Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.

    The contents of this file are subject to the terms of either the GNU
    General Public License Version 2 only ("GPL") or the Common Development
    and Distribution License("CDDL") (collectively, the "License").  You
    may not use this file except in compliance with the License.  You can
    obtain a copy of the License at
    https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
    or packager/legal/LICENSE.txt.  See the License for the specific
    language governing permissions and limitations under the License.

    When distributing the software, include this License Header Notice in each
    file and include the License file at packager/legal/LICENSE.txt.

    GPL Classpath Exception:
    Oracle designates this particular file as subject to the "Classpath"
    exception as provided by Oracle in the GPL Version 2 section of the License
    file that accompanied this code.

    Modifications:
    If applicable, add the following below the License Header, with the fields
    enclosed by brackets [] replaced by your own identifying information:
    "Portions Copyright [year] [name of copyright owner]"

    Contributor(s):
    If you wish your version of this file to be governed by only the CDDL or
    only the GPL Version 2, indicate your decision by adding "[Contributor]
    elects to include this software in this distribution under the [CDDL or GPL
    Version 2] license."  If you don't indicate a single choice of license, a
    recipient has the option to distribute your version of this file under
    either the CDDL, the GPL Version 2 or to extend the choice of license to
    its licensees as provided above.  However, if you add GPL Version 2 code
    and therefore, elected the GPL Version 2 license, then the option applies
    only if the new code is made subject to such option by the copyright
    holder.

-->

<!-- appserver/instancesTable.inc -->

<sun:table id="instancesTable" title="#{tableTitle}"
    deselectMultipleButton="$boolean{true}"
    deselectMultipleButtonOnClick="setTimeout('admingui.table.changeThreeTableButtons(\\\\\'#{pageSession.topActionGroup}\\\\\', \\\\\'#{pageSession.tableId}\\\\\');', 0)"
    selectMultipleButton="$boolean{true}"
    selectMultipleButtonOnClick="setTimeout('admingui.table.changeThreeTableButtons(\\\\\'#{pageSession.topActionGroup}\\\\\', \\\\\'#{pageSession.tableId}\\\\\');', 0)" >
     <!afterCreate
        getClientId(component="$this{component}" clientId=>$page{tableId});
    />

#include "/common/shared/listTableButtons.inc"

<sun:tableRowGroup id="rowGroup1" selected="#{td.value.selected}" data={"$attribute{listOfRows}"} sourceVar="td">
        <!afterCreate
        getClientId(component="$this{component}" clientId=>$page{tableRowGroupId});
       />

    <sun:tableColumn selectId="select" rowHeader="$boolean{false}" id="col0">
        <sun:checkbox id="select"
            selected="#{td.value.selected}"
            selectedValue="$boolean{true}"
            onClick="setTimeout('admingui.table.changeThreeTableButtons(\\\\\'#{pageSession.topActionGroup}\\\\\', \\\\\'#{pageSession.tableId}\\\\\'); admingui.table.initAllRows(\\\\\'#{pageSession.tableId}\\\\\');', 0);"
        />
    </sun:tableColumn>

    <sun:tableColumn headerText="$resource{i18n.common.name.header}" rowHeader="$boolean{true}" id="col1">
        <sun:hyperlink id="link" text="#{td.value.name}" url="#{pageSession.editLink}&instanceName=#{td.value.name}" />
    </sun:tableColumn>
    <sun:tableColumn headerText="$resource{i18ncs.standalone.ColWeight}" rowHeader="$boolean{true}" id="col2">
        <sun:textField id="weight" columns="$int{10}" maxLength="#{sessionScope.fieldLengths['maxLength.standalone.lbWeight']}" text="#{td.value.lbWeight}" />
    </sun:tableColumn>
    <sun:tableColumn headerText="$resource{i18ncs.common.ConfigurationCol}" rowHeader="$boolean{true}" id="col3">
        <sun:hyperlink id="configlink" text="#{td.value.configRef}" url="/configuration/configuration.jsf?configName=#{td.value.configRef}" />
    </sun:tableColumn>
    <sun:tableColumn headerText="$resource{i18ncs.common.NodeCol}" rowHeader="$boolean{true}" id="col5">
        <sun:hyperlink id="nodeAgentlink" text="#{td.value.node}"  url="#{request.contextPath}/cluster/node/nodeEdit.jsf?nodeName=#{td.value.node}" />
    </sun:tableColumn>
   <sun:tableColumn headerText="$resource{i18n.common.Status}" rowHeader="$boolean{true}" id="col6">
        <staticText id="statusCol" value="#{requestScope.statusString}" >
            <!beforeEncode
                createMap(result="#{pageSession.statusAttrs}")
                mapPut(map="#{pageSession.statusAttrs}" key="DEFAULT" value="#{td.value.name}" );
                setAttribute(key="in", value="#{td.value.name}" );
                gf.callRestAndExtractMsgProps(
                    endpoint="#{sessionScope.REST_URL}/list-instances.xml"
                    attrs="#{pageSession.statusAttrs}"
                    method="GET"
                    propsMap="#{pageSession.propsMap}");
                gf.restRequest(
                    endpoint="#{sessionScope.REST_URL}/list-instances.xml"
                    attrs="#{pageSession.attrs}"
                    method="GET"
                    result="#{pageSession.listInstanceResult}");
                setAttribute(key="status" value="#{pageSession.listInstanceResult['data']['properties']['${in}']}");
                setAttribute(key="statusString" value="$resource{i18nc.status.$attribute{status}}  &nbsp; $resource{i18nc.status.image.$attribute{status}}");
                />
        </staticText>
    </sun:tableColumn>
</sun:tableRowGroup>

</sun:table>
