/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.SCPClient;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.HostVerifier;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="SSHLauncher")
@Scoped(value=PerLookup.class)
public class SSHLauncher {
    private static final String SSH_DIR = ".ssh/";
    private static final String AUTH_KEY_FILE = "authorized_keys";
    private static KnownHosts knownHostsDatabase = new KnownHosts();
    private String host;
    private int port;
    private String userName;
    private String keyFile;
    private Connection connection;
    private String authType;
    private String keyPassPhrase;
    private File knownHosts;
    private Logger logger;
    private String password;
    private String rawPassword = null;
    private String rawKeyPassPhrase = null;
    @Inject
    private Habitat habitat;

    public void init(Node node, Logger logger) {
        int port;
        String sshHost;
        this.logger = logger;
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Connecting to host " + host);
        }
        if ((sshHost = connector.getSshHost()) != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = sshAuth.getKeyfile();
            this.rawPassword = sshAuth.getPassword();
            this.rawKeyPassPhrase = sshAuth.getKeyPassphrase();
        }
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.init(userName, this.host, port, this.rawPassword, this.keyFile, this.rawKeyPassPhrase, logger);
    }

    public void init(String userName, String host, int port, String password, String keyFile, String keyPassPhrase, Logger logger) {
        this.port = port == 0 ? 22 : port;
        this.host = host;
        this.keyFile = keyFile == null ? this.findDefaultKeyFile() : keyFile;
        this.logger = logger;
        this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        this.rawPassword = password;
        this.password = this.expandPasswordAlias(password);
        this.rawKeyPassPhrase = keyPassPhrase;
        this.keyPassPhrase = this.expandPasswordAlias(keyPassPhrase);
        if (this.knownHosts == null) {
            File home = new File(System.getProperty("user.home"));
            this.knownHosts = new File(home, ".ssh/known_hosts");
        }
        if (this.knownHosts.exists()) {
            try {
                knownHostsDatabase.addHostkeys(this.knownHosts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SSH info is " + this.toString());
        }
    }

    private void openConnection() throws IOException {
        boolean isAuthenticated = false;
        this.connection = new Connection(this.host, this.port);
        this.connection.connect(new HostVerifier(knownHostsDatabase));
        if (SSHUtil.checkString(this.keyFile) == null && SSHUtil.checkString(this.password) == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("keyfile and password are null. Will try to authenticate with default key file if available");
            }
            File home = new File(System.getProperty("user.home"));
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File key = new File(home, SSH_DIR + keyName);
                if (key.exists()) {
                    isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, null);
                }
                if (!isAuthenticated) continue;
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Authentication successful using key " + keyName);
                break;
            }
        }
        if (!isAuthenticated && SSHUtil.checkString(this.keyFile) != null) {
            File key;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Specified key file is " + this.keyFile);
            }
            if ((key = new File(this.keyFile)).exists()) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Specified key file exists at " + key);
                }
                isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, this.keyPassPhrase);
            }
        }
        if (!isAuthenticated && SSHUtil.checkString(this.password) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Authenticating with password " + this.getPrintablePassword(this.password));
            }
            isAuthenticated = this.connection.authenticateWithPassword(this.userName, this.password);
        }
        if (!isAuthenticated && !this.connection.isAuthenticationComplete()) {
            this.connection.close();
            this.connection = null;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not authenticate");
            }
            throw new IOException("Could not authenticate");
        }
        SSHUtil.register(this.connection);
    }

    public int runCommand(String command, OutputStream os) throws IOException, InterruptedException {
        this.logger.fine("Running command " + command + " on host: " + this.host);
        this.openConnection();
        int status = this.connection.exec(command, os);
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return status;
    }

    public void validate(String host, int port, String userName, String password, String keyFile, String keyPassPhrase, String nodeHome, Logger logger) throws IOException {
        boolean validNodeHome = false;
        this.init(userName, host, port, password, keyFile, keyPassPhrase, logger);
        this.openConnection();
        logger.fine("Connection settings valid");
        SFTPClient sftpClient = new SFTPClient(this.connection);
        validNodeHome = sftpClient.exists(nodeHome);
        logger.fine("Node home validated");
        SSHUtil.unregister(this.connection);
        this.connection = null;
        if (!validNodeHome) {
            throw new FileNotFoundException("Could not find " + nodeHome + " on " + host);
        }
    }

    public SFTPClient getSFTPClient() throws IOException {
        this.openConnection();
        SFTPClient sftpClient = new SFTPClient(this.connection);
        return sftpClient;
    }

    public SCPClient getSCPClient() throws IOException {
        this.openConnection();
        return new SCPClient(this.connection);
    }

    public String expandPasswordAlias(String alias) {
        String expandedPassword = null;
        if (alias == null) {
            return null;
        }
        try {
            expandedPassword = RelativePathResolver.getRealPasswordFromAlias((String)alias);
        }
        catch (Exception e) {
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{alias, e.getMessage()}));
            return null;
        }
        return expandedPassword;
    }

    public boolean isPasswordAlias(String alias) {
        String aliasName = RelativePathResolver.getAlias((String)alias);
        return aliasName != null;
    }

    private String getPrintablePassword(String p) {
        String printable = "null";
        if (p != null) {
            printable = this.isPasswordAlias(p) ? p : "<concealed>";
        }
        return printable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupKey(String node, String pubKeyFile) throws IOException {
        boolean connected = false;
        File key = new File(this.keyFile);
        this.logger.fine("Key = " + this.keyFile);
        if (key.exists()) {
            if (this.checkConnection()) {
                this.logger.fine("SSH key already setup");
                return;
            }
            if (pubKeyFile == null) {
                pubKeyFile = this.findDefaultKeyFile() + ".pub";
            }
        } else {
            throw new IOException("SSH key pair not present. Please generate a key pair manually and re-run the command.");
        }
        if (this.password == null) {
            throw new IOException("SSH password is required for distributing the public key. You can specify the SSH password alias in a password file and pass it through --passwordfile option.");
        }
        try {
            this.connection = new Connection(node, this.port);
            this.connection.connect();
            connected = this.connection.authenticateWithPassword(this.userName, this.password);
        }
        catch (Exception ex) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        if (!connected) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        SCPClient scp = new SCPClient(this.connection);
        if (key.exists()) {
            File pubKey = new File(pubKeyFile);
            if (!pubKey.exists()) {
                throw new IOException("Public key file " + pubKeyFile + " does not exist.");
            }
            ByteArrayOutputStream out = null;
            OutputStream oStream = null;
            InputStream sendFile = null;
            File f = null;
            try {
                out = new ByteArrayOutputStream();
                try {
                    scp.get(".ssh/authorized_keys", out);
                }
                catch (IOException io) {
                    // empty catch block
                }
                this.logger.fine("Got the remote authorized_keys file");
                File home = new File(System.getProperty("user.home"));
                f = new File(home, ".ssh/authorized_keys.temp");
                oStream = new FileOutputStream(f);
                out.writeTo(oStream);
                this.logger.fine("Wrote the temp file");
                this.appendPublicKey(pubKey, f);
                sendFile = new FileInputStream(f);
                byte[] theBytes = new byte[sendFile.available()];
                sendFile.read(theBytes);
                scp.put(theBytes, AUTH_KEY_FILE, SSH_DIR);
                this.logger.fine("Sent the merged file");
            }
            catch (FileNotFoundException fne) {
            }
            catch (IOException ioe) {
            }
            finally {
                f.delete();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException io) {}
                }
                if (oStream != null) {
                    try {
                        oStream.close();
                    }
                    catch (IOException io) {}
                }
                if (sendFile != null) {
                    try {
                        sendFile.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
    }

    private void appendPublicKey(File pubKey, File f) {
        try {
            int c;
            BufferedWriter out = new BufferedWriter(new FileWriter(f, true));
            FileInputStream in = new FileInputStream(pubKey);
            while ((c = ((InputStream)in).read()) != -1) {
                out.write(c);
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) >= 0) {
            output.write(buf, 0, len);
        }
        byte[] o = output.toByteArray();
        output.close();
        return o;
    }

    public boolean checkConnection() {
        boolean status = false;
        Connection c = null;
        try {
            c = new Connection(this.host, this.port);
            c.connect();
            File f = new File(this.keyFile);
            status = c.authenticateWithPublicKey(this.userName, f, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        c.close();
        return status;
    }

    private String findDefaultKeyFile() {
        String key = null;
        for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
            String h = System.getProperty("user.home") + File.separator;
            File f = new File(h + SSH_DIR + keyName);
            if (!f.exists()) continue;
            key = h + SSH_DIR + keyName;
            break;
        }
        return key;
    }

    public String toString() {
        String knownHostsPath = "null";
        if (this.knownHosts != null) {
            try {
                knownHostsPath = this.knownHosts.getCanonicalPath();
            }
            catch (IOException e) {
                knownHostsPath = this.knownHosts.getAbsolutePath();
            }
        }
        String displayPassword = this.getPrintablePassword(this.rawPassword);
        String displayKeyPassPhrase = this.getPrintablePassword(this.rawKeyPassPhrase);
        return String.format("host=%s port=%d user=%s password=%s keyFile=%s keyPassPhrase=%s authType=%s knownHostFile=%s", this.host, this.port, this.userName, displayPassword, this.keyFile, displayKeyPassPhrase, this.authType, knownHostsPath);
    }
}

