/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="postcreateapplicationref")
@Supplemental(value="create-application-ref", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class PostCreateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PostCreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true, defaultValue="true")
    public Boolean lbenabled = true;
    @Inject
    private Deployment deployment;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        if (suppInfo.isAppRefExists()) {
            return;
        }
        DeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(dc);
            ArrayList<String> targets = new ArrayList<String>(Arrays.asList(params.target.split(",")));
            ClusterOperationUtil.replicateCommand((String)"_deploy", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

