/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ssl.SecuritySupportImpl;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.enterprise.universal.GFBase64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class JarSigner {
    private static final GFBase64Encoder b64encoder = new GFBase64Encoder();
    private final MessageDigest md;
    private final String digestAlgorithm;
    private final String keyAlgorithm;
    private static final SecuritySupport secSupp = new SecuritySupportImpl();

    public JarSigner(String digestAlgorithm, String keyAlgorithm) throws NoSuchAlgorithmException {
        this.digestAlgorithm = digestAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.md = MessageDigest.getInstance(digestAlgorithm);
    }

    public static void main(String[] args) throws Exception {
        File in = new File(args[0]);
        File out = new File(args[1]);
        new JarSigner("SHA1", "RSA").signJar(in, out, "s1as");
    }

    private String hash(String content) {
        return b64encoder.encodeBuffer(this.md.digest(content.getBytes())).trim();
    }

    private String hash(JarFile jf, JarEntry je) throws IOException {
        byte[] data = JarSigner.readJarEntry(jf, je);
        return b64encoder.encodeBuffer(this.md.digest(data)).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signJar(File input, File output, String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException, SignatureException {
        JarFile jf = new JarFile(input);
        try {
            Enumeration<JarEntry> jes;
            boolean signed;
            StringBuilder manifestEntries = new StringBuilder();
            byte[] manifestContent = null;
            byte[] sigFileContent = JarSigner.getExistingSignatureFile(jf);
            boolean bl = signed = sigFileContent != null;
            if (!signed) {
                jes = jf.entries();
                Manifest manifest = this.retrieveManifest(jf);
                StringBuilder manifestHeader = new StringBuilder();
                JarSigner.appendAttributes(manifestHeader, manifest, null);
                StringBuilder sigFileEntries = new StringBuilder();
                while (jes.hasMoreElements()) {
                    JarEntry je = jes.nextElement();
                    String name = je.getName();
                    if (je.isDirectory() && manifest.getAttributes(name) == null || name.equals("META-INF/MANIFEST.MF")) continue;
                    StringBuilder me = new StringBuilder();
                    StringBuilder currentLine = new StringBuilder();
                    currentLine.append("Name: ").append(name);
                    JarSigner.appendLine(me, currentLine);
                    currentLine.setLength(0);
                    me.append(this.digestAlgorithm).append("-Digest: ").append(this.hash(jf, je)).append("\r\n");
                    JarSigner.appendAttributes(me, manifest, name);
                    currentLine.append("Name: ").append(name);
                    JarSigner.appendLine(sigFileEntries, currentLine);
                    currentLine.setLength(0);
                    sigFileEntries.append(this.digestAlgorithm).append("-Digest: ").append(this.hash(me.toString())).append("\r\n\r\n");
                    manifestEntries.append((CharSequence)me);
                }
                StringBuilder sigFile = new StringBuilder("Signature-Version: 1.0\r\n").append(this.digestAlgorithm).append("-Digest-Manifest-Main-Attributes: ").append(this.hash(manifestHeader.toString())).append("\r\n").append("Created-By: ").append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.vendor")).append(")\r\n");
                manifestHeader.append((CharSequence)manifestEntries);
                sigFile.append(this.digestAlgorithm).append("-Digest-Manifest: ").append(this.hash(manifestHeader.toString())).append("\r\n\r\n");
                sigFile.append((CharSequence)sigFileEntries);
                manifestContent = manifestHeader.toString().getBytes();
                sigFileContent = sigFile.toString().getBytes();
            } else {
                manifestContent = JarSigner.readJarEntry(jf, jf.getJarEntry("META-INF/MANIFEST.MF"));
            }
            X509Certificate[] certChain = null;
            PrivateKey privKey = null;
            KeyStore[] ks = secSupp.getKeyStores();
            for (int i = 0; i < ks.length; ++i) {
                privKey = secSupp.getPrivateKeyForAlias(alias, i);
                if (privKey == null) continue;
                Certificate[] cs = ks[i].getCertificateChain(alias);
                certChain = new X509Certificate[cs.length];
                for (int j = 0; j < cs.length; ++j) {
                    certChain[j] = (X509Certificate)cs[j];
                }
            }
            Signature sig = Signature.getInstance(this.digestAlgorithm + "with" + this.keyAlgorithm);
            sig.initSign(privKey);
            sig.update(sigFileContent);
            PKCS7 pkcs7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get(this.digestAlgorithm)}, new ContentInfo(sigFileContent), certChain, new SignerInfo[]{new SignerInfo((X500Name)certChain[0].getIssuerDN(), certChain[0].getSerialNumber(), AlgorithmId.get(this.digestAlgorithm), AlgorithmId.get(this.keyAlgorithm), sig.sign())});
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            pkcs7.encodeSignedData(bout);
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));
            zout.putNextEntry(signed ? JarSigner.getZipEntry(jf.getJarEntry("META-INF/MANIFEST.MF")) : new ZipEntry("META-INF/MANIFEST.MF"));
            zout.write(manifestContent);
            zout.putNextEntry(new ZipEntry("META-INF/" + alias.toUpperCase(Locale.US) + ".SF"));
            zout.write(sigFileContent);
            zout.putNextEntry(new ZipEntry("META-INF/" + alias.toUpperCase(Locale.US) + "." + this.keyAlgorithm));
            zout.write(bout.toByteArray());
            jes = jf.entries();
            while (jes.hasMoreElements()) {
                JarEntry je = jes.nextElement();
                String name = je.getName();
                if (name.equals("META-INF/MANIFEST.MF")) continue;
                zout.putNextEntry(JarSigner.getZipEntry(je));
                byte[] data = JarSigner.readJarEntry(jf, je);
                zout.write(data);
            }
            zout.close();
        }
        finally {
            jf.close();
        }
    }

    private Manifest retrieveManifest(JarFile jf) throws IOException {
        Manifest manifest = jf.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            mainAttributes.putValue("Created-By", System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        }
        Map<String, Attributes> entriesMap = manifest.getEntries();
        Iterator<String> entries = entriesMap.keySet().iterator();
        while (entries.hasNext()) {
            if (jf.getJarEntry(entries.next()) != null) continue;
            entries.remove();
        }
        return manifest;
    }

    private static StringBuilder appendAttributes(StringBuilder manifestEntry, Manifest manifest, String entry) {
        Attributes attributes = entry == null ? manifest.getMainAttributes() : manifest.getAttributes(entry);
        StringBuilder line = new StringBuilder();
        if (attributes != null) {
            for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                line.append(attr.getKey().toString()).append(": ").append((String)attr.getValue());
                JarSigner.appendLine(manifestEntry, line);
                line.setLength(0);
            }
        }
        return manifestEntry.append("\r\n");
    }

    private static StringBuilder appendLine(StringBuilder sb, StringBuilder line) {
        int begin = 0;
        int end = 70;
        while (line.length() - begin > 70) {
            sb.append(line.subSequence(begin, end)).append("\r\n ");
            begin = end;
            end += 69;
        }
        return sb.append(line.subSequence(begin, line.length())).append("\r\n");
    }

    private static byte[] getExistingSignatureFile(JarFile jf) throws IOException {
        Enumeration<JarEntry> entries = jf.entries();
        JarEntry je = null;
        while (entries.hasMoreElements()) {
            JarEntry cje = entries.nextElement();
            if (!cje.getName().startsWith("META-INF/") || !cje.getName().endsWith(".SF")) continue;
            je = cje;
            break;
        }
        return JarSigner.readJarEntry(jf, je);
    }

    private static byte[] readJarEntry(JarFile jf, JarEntry je) throws IOException {
        int current;
        if (je == null) {
            return null;
        }
        byte[] data = new byte[(int)je.getSize()];
        InputStream jis = jf.getInputStream(je);
        int idx = 0;
        while ((current = jis.read()) > -1) {
            data[idx++] = (byte)current;
        }
        return data;
    }

    private static ZipEntry getZipEntry(JarEntry je) {
        ZipEntry ze = new ZipEntry(je.getName());
        ze.setComment(je.getComment());
        ze.setCrc(je.getCrc());
        ze.setExtra(je.getExtra());
        ze.setMethod(je.getMethod());
        ze.setSize(je.getSize());
        ze.setTime(je.getTime());
        return ze;
    }
}

