/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.BundleClassLoader;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.web.loader.ResourceEntry;
import org.glassfish.web.loader.WebappClassLoader;
import org.osgi.framework.Bundle;

class OSGiWebDeploymentContext
extends OSGiDeploymentContext {
    private static final Logger logger = Logger.getLogger(OSGiWebDeploymentContext.class.getPackage().getName());

    public OSGiWebDeploymentContext(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env, Bundle bundle) throws Exception {
        super(actionReport, logger, source, params, env, bundle);
    }

    protected void setupClassLoader() throws Exception {
        final BundleClassLoader delegate1 = new BundleClassLoader(this.bundle);
        final ClassLoader delegate2 = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getAPIClassLoader();
        ClassLoader parent = new ClassLoader(){

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return delegate1.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe) {
                    return delegate2.loadClass(name);
                }
            }

            @Override
            public URL getResource(String name) {
                URL url = delegate1.getResource(name);
                if (url == null) {
                    url = delegate2.getResource(name);
                }
                return url;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                enumerators.add(delegate1.getResources(name));
                enumerators.add(delegate2.getResources(name));
                return new CompositeEnumeration(enumerators);
            }
        };
        this.shareableTempClassLoader = this.finalClassLoader = new WABClassLoader(parent);
        ((WebappClassLoader)WebappClassLoader.class.cast(this.finalClassLoader)).start();
    }

    private class WABClassLoader
    extends WebappClassLoader {
        public WABClassLoader(ClassLoader parent) {
            super(parent);
            FileDirContext r = new FileDirContext();
            File base = OSGiWebDeploymentContext.this.getSourceDir();
            r.setDocBase(base.getAbsolutePath());
            this.setResources((DirContext)r);
            this.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
            File libDir = new File(base, "WEB-INF/lib");
            if (libDir.exists()) {
                int baseFileLen = base.getPath().length();
                for (File file : libDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String fileName = pathname.getName();
                        return fileName.endsWith(".jar") && pathname.isFile();
                    }
                })) {
                    try {
                        this.addJar(file.getPath().substring(baseFileLen), new JarFile(file), file);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.setWorkDir(OSGiWebDeploymentContext.this.getScratchDir("jsp"));
        }

        public URL[] getURLs() {
            return this.convert((String)OSGiWebDeploymentContext.this.bundle.getHeaders().get("Bundle-ClassPath"));
        }

        private URL[] convert(String bcp) {
            if (bcp == null || bcp.isEmpty()) {
                bcp = ".";
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            StringTokenizer entries = new StringTokenizer(bcp, ",;");
            while (entries.hasMoreTokens()) {
                String entry = entries.nextToken().trim();
                if (entry.startsWith("/")) {
                    entry = entry.substring(1);
                }
                try {
                    URL url = new File(OSGiWebDeploymentContext.this.getSourceDir(), entry).toURI().toURL();
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    logger.logp(Level.WARNING, "OSGiDeploymentContext", "convert", "Failed to add {0} as classpath because of", new Object[]{entry, e.getMessage()});
                }
            }
            return urls.toArray(new URL[0]);
        }

        public URL getResource(String name) {
            if (name.startsWith("META-INF/resources/")) {
                URL url = super.findResource(name);
                if (url != null) {
                    ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
                    try {
                        String repository = entry.codeBase.toString();
                        if (repository.endsWith(".jar") && !name.endsWith(".class") && !name.endsWith(".jar")) {
                            File resourceFile = new File(this.loaderDir, name);
                            url = resourceFile.toURL();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return url;
                }
            } else {
                return super.getResource(name);
            }
            return null;
        }
    }
}

