/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgiweb.OSGiWebDeploymentContext;
import org.glassfish.osgiweb.WAB;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiWebDeploymentRequest
extends OSGiDeploymentRequest {
    public OSGiWebDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        super(deployer, archiveFactory, env, reporter, b);
    }

    protected OSGiDeploymentContext getDeploymentContextImpl(ActionReport reporter, Logger logger, ReadableArchive archive, OpsParams opsParams, ServerEnvironmentImpl env, Bundle b) throws Exception {
        return new OSGiWebDeploymentContext(reporter, logger, archive, opsParams, (ServerEnvironment)env, b);
    }

    protected WAB makeArchive() {
        Bundle host = this.getBundle();
        Bundle[] fragments = this.getPackageAdmin().getFragments(host);
        return new WAB(host, fragments);
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext ctx = ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
        return (PackageAdmin)PackageAdmin.class.cast(ctx.getService(ctx.getServiceReference(PackageAdmin.class.getName())));
    }

    protected DeployCommandParameters getDeployParams() throws Exception {
        DeployCommandParameters parameters = super.getDeployParams();
        try {
            parameters.contextroot = this.getArchive().getManifest().getMainAttributes().getValue("Web-ContextPath");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (parameters.contextroot == null || parameters.contextroot.length() == 0) {
            throw new Exception("Web-ContextPath manifest header is mandatory");
        }
        parameters.virtualservers = this.getVirtualServers();
        return parameters;
    }

    private String getVirtualServers() {
        StringTokenizer st;
        String virtualServers = null;
        try {
            virtualServers = this.getArchive().getManifest().getMainAttributes().getValue("Virtual-Servers");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (virtualServers == null) {
            virtualServers = this.getDefaultVirtualServer();
        }
        if ((st = new StringTokenizer(virtualServers)).countTokens() > 1) {
            throw new IllegalArgumentException("Currently, we only support deployment to one virtual server.");
        }
        return virtualServers;
    }

    private String getAllVirtualServers() {
        List hosts;
        HttpService httpService;
        Config config;
        String target;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(target = "server");
        if (server != null && (config = domain.getConfigs().getConfigByName(server.getConfigRef())) != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    private String getDefaultVirtualServer() {
        NetworkListener nl = (NetworkListener)Globals.get(NetworkListener.class);
        return nl.findHttpProtocol().getHttp().getDefaultVirtualServer();
    }
}

