/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.NonOSGiGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.experimentalgfapi.Constants;
import org.glassfish.experimentalgfapi.GlassFishRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonOSGiGlassFishRuntimeBuilder
implements GlassFishRuntime.RuntimeBuilder {
    private static Logger logger = Util.getLogger();
    private static final String JAR_EXT = ".jar";

    @Override
    public GlassFishRuntime build(Properties properties) throws Exception {
        String installRoot = ASMainHelper.findInstallRoot().getAbsolutePath();
        List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
        StaticClassLoader cl = new StaticClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
        EmbeddedMain main = new EmbeddedMain();
        SingleHK2Factory.initialize(cl);
        ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
        modulesRegistry.setParentClassLoader(cl);
        NonOSGiGlassFishRuntime glassFishRuntime = new NonOSGiGlassFishRuntime(main);
        logger.logp(Level.INFO, this.getClass().getName(), "build", "Created GlassFishRuntime {0} with Bootstrap Properties {1}", new Object[]{glassFishRuntime, properties});
        return glassFishRuntime;
    }

    @Override
    public boolean handles(Properties properties) {
        Constants.Platform platform = Constants.Platform.valueOf(properties.getProperty("GlassFish_Platform", Constants.Platform.Felix.name()));
        switch (platform) {
            case Static: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroy() throws Exception {
    }

    private List<URL> getModuleJarURLs(String installRoot) {
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        modulesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(NonOSGiGlassFishRuntimeBuilder.JAR_EXT)) {
                    try {
                        moduleJarURLs.add(pathname.toURI().toURL());
                    }
                    catch (Exception ex) {
                        logger.warning(ex.getMessage());
                    }
                }
                return false;
            }
        });
        return moduleJarURLs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticClassLoader
    extends URLClassLoader {
        public StaticClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super(moduleJarURLs.toArray(new URL[0]), parent);
        }
    }
}

