/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.DataSource;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

@ConnectionDefinition(connectionFactory=javax.sql.DataSource.class, connectionFactoryImpl=DataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class XAManagedConnectionFactory
extends ManagedConnectionFactory {
    private transient XADataSource xaDataSourceObj;
    private static Logger _logger = LogDomains.getLogger(XAManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    @Override
    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        XADataSource dataSource = this.getDataSource();
        XAConnection xaConn = null;
        try {
            xaConn = this.isEqual(pc, this.getUser(), this.getPassword()) ? dataSource.getXAConnection() : dataSource.getXAConnection(pc.getUserName(), new String(pc.getPassword()));
        }
        catch (SQLException sqle) {
            _logger.log(Level.FINE, "jdbc.exc_create_xa_conn", sqle);
            StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
            String msg = sm.getString("jdbc.cannot_allocate_connection", (Object)sqle.getMessage());
            throw new ResourceAllocationException(msg, (Throwable)sqle);
        }
        ManagedConnection mc = this.constructManagedConnection(xaConn, null, pc, this);
        mc.initializeConnectionType(2);
        this.validateAndSetIsolation(mc);
        return mc;
    }

    @Override
    public XADataSource getDataSource() throws ResourceException {
        if (this.xaDataSourceObj == null) {
            try {
                this.xaDataSourceObj = (XADataSource)super.getDataSource();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce_XA", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        return this.xaDataSourceObj;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof XAManagedConnectionFactory) {
            XAManagedConnectionFactory otherMCF = (XAManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    @ConfigProperty(type=String.class, defaultValue="org.apache.derby.jdbc.ClientXADataSource")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public void setMaxStatements(String maxStmts) {
        this.spec.setDetail(13, maxStmts);
    }

    public String getMaxStatements() {
        return this.spec.getDetail(13);
    }

    public void setInitialPoolSize(String initPoolSz) {
        this.spec.setDetail(14, initPoolSz);
    }

    public String getInitialPoolSize() {
        return this.spec.getDetail(14);
    }

    public void setMinPoolSize(String minPoolSz) {
        this.spec.setDetail(15, minPoolSz);
    }

    public String getMinPoolSize() {
        return this.spec.getDetail(15);
    }

    public void setMaxPoolSize(String maxPoolSz) {
        this.spec.setDetail(16, maxPoolSz);
    }

    public String getMaxPoolSize() {
        return this.spec.getDetail(16);
    }

    public void setMaxIdleTime(String maxIdleTime) {
        this.spec.setDetail(17, maxIdleTime);
    }

    public String getMaxIdleTime() {
        return this.spec.getDetail(17);
    }

    public void setPropertyCycle(String propCycle) {
        this.spec.setDetail(18, propCycle);
    }

    public String getPropertyCycle() {
        return this.spec.getDetail(18);
    }
}

