/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.base.EventPacket;
import com.sun.enterprise.ee.cms.impl.base.GroupCommunicationProviderImpl;
import com.sun.enterprise.ee.cms.impl.base.GroupHandleImpl;
import com.sun.enterprise.ee.cms.impl.base.MessagePacket;
import com.sun.enterprise.ee.cms.impl.base.MessageWindow;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.base.ViewWindowImpl;
import com.sun.enterprise.ee.cms.impl.common.AliveAndReadyViewWindow;
import com.sun.enterprise.ee.cms.impl.common.GMSContextBase;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.ShutdownHelper;
import com.sun.enterprise.ee.cms.impl.common.ViewWindow;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class GMSContextImpl
extends GMSContextBase {
    private ArrayBlockingQueue<EventPacket> viewQueue;
    private static final int MAX_VIEWS_IN_QUEUE = 200;
    private ArrayBlockingQueue<MessagePacket> messageQueue;
    private static final int DEFAULT_INCOMING_MSG_QUEUE_SIZE = 500;
    private static int MAX_MSGS_IN_QUEUE = 500;
    private ViewWindowImpl viewWindow;
    private GroupCommunicationProvider groupCommunicationProvider;
    private DistributedStateCache distributedStateCache;
    private GroupHandle gh;
    private Properties configProperties;
    private boolean isGroupShutdown = false;
    private boolean isGroupStartup = false;
    private Thread viewWindowThread = null;
    private Thread messageWindowThread = null;
    private AliveAndReadyViewWindow aliveAndReadyViewWindow = null;
    private static final Map<String, RejoinSubevent> instanceRejoins = new ConcurrentHashMap<String, RejoinSubevent>();

    public GMSContextImpl(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties configProperties) {
        super(serverToken, groupName, memberType);
        MAX_MSGS_IN_QUEUE = Utility.getIntProperty(ServiceProviderConfigurationKeys.INCOMING_MESSAGE_QUEUE_SIZE.toString(), 500, configProperties);
        if (MAX_MSGS_IN_QUEUE != 500 && logger.isLoggable(Level.CONFIG)) {
            logger.config("INCOMING_MESSAGE_QUEUE_SIZE: " + MAX_MSGS_IN_QUEUE + " overrides default value of " + 500);
        }
        this.router = new Router(MAX_MSGS_IN_QUEUE + 100);
        this.configProperties = configProperties;
        this.groupCommunicationProvider = new GroupCommunicationProviderImpl(groupName);
        if (this.isWatchdog()) {
            this.viewQueue = null;
            this.viewWindow = null;
        } else {
            this.viewQueue = new ArrayBlockingQueue(200, Boolean.TRUE);
            this.viewWindow = new ViewWindowImpl(groupName, this.viewQueue);
        }
        this.messageQueue = new ArrayBlockingQueue(MAX_MSGS_IN_QUEUE, Boolean.TRUE);
        this.gh = new GroupHandleImpl(groupName, serverToken);
        this.createDistributedStateCache();
        long MAX_STARTCLUSTER_DURATION_MS = Utility.getLongProperty("MAX_STARTCLUSTER_DURATION_MS", 10000L, configProperties);
        this.aliveAndReadyViewWindow = new AliveAndReadyViewWindow(this);
        this.aliveAndReadyViewWindow.setStartClusterMaxDuration(MAX_STARTCLUSTER_DURATION_MS);
        logger.log(Level.FINE, "gms.init");
    }

    @Override
    protected void createDistributedStateCache() {
        this.distributedStateCache = this.isWatchdog() ? null : DistributedStateCacheImpl.getInstance(this.groupName);
    }

    @Override
    public GroupHandle getGroupHandle() {
        return this.gh;
    }

    @Override
    public DistributedStateCache getDistributedStateCache() {
        if (this.distributedStateCache == null && !this.isWatchdog()) {
            this.createDistributedStateCache();
        }
        return this.distributedStateCache;
    }

    @Override
    public void join() throws GMSException {
        this.viewWindowThread = this.isWatchdog() ? null : new Thread((Runnable)this.viewWindow, "ViewWindowThread:" + this.groupName);
        MessageWindow messageWindow = new MessageWindow(this.groupName, this.messageQueue);
        this.messageWindowThread = new Thread((Runnable)messageWindow, "MessageWindowThread:" + this.groupName);
        this.messageWindowThread.start();
        if (this.viewWindowThread != null) {
            this.viewWindowThread.start();
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(CustomTagNames.MEMBER_TYPE.toString(), this.memberType);
        idMap.put(CustomTagNames.GROUP_NAME.toString(), this.groupName);
        idMap.put(CustomTagNames.START_TIME.toString(), this.startTime.toString());
        try {
            this.groupCommunicationProvider.initializeGroupCommunicationProvider(this.serverToken, this.groupName, idMap, (Map)this.configProperties);
            this.groupCommunicationProvider.join();
        }
        catch (Throwable t) {
            GMSException ge = new GMSException("failed to join group " + this.groupName, t);
            throw ge;
        }
    }

    @Override
    public void leave(GMSConstants.shutdownType shutdownType2) {
        if (this.shutdownHelper.isGroupBeingShutdown(this.groupName)) {
            logger.log(Level.INFO, "shutdown.groupshutdown", new Object[]{this.groupName});
            this.groupCommunicationProvider.leave(true);
            this.isGroupShutdown = true;
            this.shutdownHelper.removeFromGroupShutdownList(this.groupName);
        } else {
            logger.log(Level.INFO, "shutdown.instanceshutdown", new Object[]{this.groupName});
            this.groupCommunicationProvider.leave(false);
        }
        this.shuttingDown = true;
        if (this.viewWindowThread != null) {
            this.viewWindowThread.interrupt();
        }
        if (this.messageWindowThread != null) {
            this.messageWindowThread.interrupt();
        }
        if (this.router != null) {
            this.router.shutdown();
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void announceGroupShutdown(String groupName, GMSConstants.shutdownState shutdownState2) {
        if (!this.getGroupCommunicationProvider().isGroupLeader()) {
            logger.log(Level.INFO, "Assuming group leadership to shutdown group: " + groupName);
            this.assumeGroupLeadership();
        }
        this.groupCommunicationProvider.announceClusterShutdown(new GMSMessage(GMSConstants.shutdownType.GROUP_SHUTDOWN.toString(), null, groupName, null));
    }

    @Override
    public void announceGroupStartup(String groupName, GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        this.groupCommunicationProvider.announceGroupStartup(groupName, startupState, memberTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToSuspectList(String token) {
        boolean retval = false;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (!this.suspectList.contains(token)) {
                this.suspectList.add(token);
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromSuspectList(String token) {
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (this.suspectList.contains(token)) {
                this.suspectList.remove(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspected(String token) {
        boolean retval = false;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (this.suspectList.contains(token)) {
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSuspectList() {
        ArrayList<String> retval;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            retval = new ArrayList<String>(this.suspectList);
        }
        return retval;
    }

    @Override
    public ShutdownHelper getShutdownHelper() {
        return this.shutdownHelper;
    }

    ArrayBlockingQueue<EventPacket> getViewQueue() {
        return this.viewQueue;
    }

    ArrayBlockingQueue<MessagePacket> getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public GroupCommunicationProvider getGroupCommunicationProvider() {
        return this.groupCommunicationProvider;
    }

    @Override
    public ViewWindow getViewWindow() {
        return this.viewWindow;
    }

    @Override
    public void assumeGroupLeadership() {
        this.groupCommunicationProvider.assumeGroupLeadership();
    }

    @Override
    public boolean isGroupBeingShutdown(String groupName) {
        return this.isGroupShutdown || this.getShutdownHelper().isGroupBeingShutdown(groupName);
    }

    @Override
    public boolean isGroupStartup() {
        return this.isGroupStartup;
    }

    @Override
    public void setGroupStartup(boolean value) {
        this.isGroupStartup = value;
    }

    @Override
    public boolean isWatchdog() {
        return this.getMemberType() == GroupManagementService.MemberType.WATCHDOG;
    }

    public int outstandingNotifications() {
        return this.viewQueue.size();
    }

    @Override
    public AliveAndReadyView getPreviousAliveAndReadyView() {
        if (this.aliveAndReadyViewWindow != null) {
            return this.aliveAndReadyViewWindow.getPreviousView();
        }
        return null;
    }

    @Override
    public AliveAndReadyView getCurrentAliveAndReadyView() {
        if (this.aliveAndReadyViewWindow != null) {
            return this.aliveAndReadyViewWindow.getCurrentView();
        }
        return null;
    }

    @Override
    public Map<String, RejoinSubevent> getInstanceRejoins() {
        return instanceRejoins;
    }

    @Override
    public AliveAndReadyViewWindow getAliveAndReadyViewWindow() {
        return this.aliveAndReadyViewWindow;
    }

    @Override
    public void setGroupStartupJoinMembers(Set<String> members) {
        this.viewWindow.setPendingGroupJoins(members);
    }

    @Override
    public boolean isGroupStartupComplete() {
        return this.viewWindow.isGroupStartupComplete();
    }

    @Override
    public boolean setGroupStartupState(String member, MemberStates state) {
        return this.viewWindow.setGroupStartupState(member, state);
    }
}

