/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.mgmt.transport.Buffer;
import com.sun.enterprise.mgmt.transport.BufferUtils;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class ByteBuffersBuffer
implements Buffer {
    private int position;
    private int limit;
    private int capacity;
    private long lastLocatedInfo = -1L;
    private int lastLocatedPosition = -1;
    private ByteBuffer[] buffers;
    private int buffersSize;
    private ByteOrder byteOrder = ByteOrder.nativeOrder();

    public ByteBuffersBuffer() {
        this((ByteBuffer[])null);
    }

    public ByteBuffersBuffer(ByteBuffer[] buffers) {
        this.set(buffers);
    }

    public ByteBuffersBuffer(ByteBuffersBuffer that) {
        this.copy(that);
    }

    private void set(ByteBuffer[] buffers) {
        if (buffers == null) {
            this.buffers = new ByteBuffer[4];
        } else {
            this.buffers = buffers;
            this.buffersSize = buffers.length;
        }
        this.limit = this.capacity = this.calcCapacity();
    }

    private ByteBuffersBuffer copy(ByteBuffersBuffer that) {
        this.buffers = Arrays.copyOf(that.buffers, that.buffers.length);
        this.buffersSize = that.buffersSize;
        this.position = that.position;
        this.limit = that.limit;
        this.capacity = that.capacity;
        return this;
    }

    @Override
    public void dispose() {
        this.removeBuffers();
    }

    public ByteBuffersBuffer append(ByteBuffer buffer) {
        this.ensureBuffersCapacity(1);
        this.buffers[this.buffersSize++] = buffer;
        this.capacity += buffer.remaining();
        this.limit = this.capacity;
        return this;
    }

    public ByteBuffersBuffer prepend(ByteBuffer buffer) {
        this.ensureBuffersCapacity(1);
        System.arraycopy(this.buffers, 0, this.buffers, 1, this.buffersSize);
        this.buffers[0] = buffer;
        ++this.buffersSize;
        this.capacity += buffer.remaining();
        this.limit = this.capacity;
        return this;
    }

    private void ensureBuffersCapacity(int newElementsNum) {
        int newSize = this.buffersSize + newElementsNum;
        if (newSize > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, Math.max(newSize, this.buffers.length * 3 / 2 + 1));
        }
    }

    public ByteBuffer[] underlying() {
        return this.buffers;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public ByteBuffersBuffer position(int newPosition) {
        this.setPosLim(newPosition, this.limit);
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public ByteBuffersBuffer limit(int newLimit) {
        this.setPosLim(this.position, newLimit);
        return this;
    }

    public void recalcCapacity() {
        this.capacity = this.calcCapacity();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuffersBuffer mark() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteBuffersBuffer reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteBuffersBuffer clear() {
        this.capacity = this.calcCapacity();
        this.setPosLim(0, this.capacity);
        return this;
    }

    @Override
    public ByteBuffersBuffer flip() {
        this.setPosLim(0, this.position);
        return this;
    }

    @Override
    public ByteBuffersBuffer rewind() {
        this.setPosLim(0, this.limit);
        return this;
    }

    @Override
    public int remaining() {
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.limit > this.position;
    }

    @Override
    public boolean disposeUnused() {
        int i;
        if (this.position == this.limit) {
            this.removeBuffers();
            return true;
        }
        long posLocation = this.locateBufferPosition(this.position);
        long limitLocation = this.locateBufferLimit(this.limit);
        int posBufferIndex = ByteBuffersBuffer.getBufferIndex(posLocation);
        int limitBufferIndex = ByteBuffersBuffer.getBufferIndex(limitLocation);
        int leftTrim = posBufferIndex;
        int rightTrim = this.buffersSize - limitBufferIndex - 1;
        if (leftTrim == 0 && rightTrim == 0) {
            return false;
        }
        for (i = 0; i < leftTrim; ++i) {
            ByteBuffer buffer = this.buffers[i];
            int bufferSize = buffer.remaining();
            this.setPosLim(this.position - bufferSize, this.limit - bufferSize);
            this.capacity -= bufferSize;
        }
        for (i = 0; i < rightTrim; ++i) {
            int idx = this.buffersSize - i - 1;
            ByteBuffer buffer = this.buffers[idx];
            this.buffers[idx] = null;
            int bufferSize = buffer.remaining();
            this.capacity -= bufferSize;
        }
        this.buffersSize -= leftTrim + rightTrim;
        this.resetLastLocation();
        if (leftTrim > 0) {
            System.arraycopy(this.buffers, leftTrim, this.buffers, 0, this.buffersSize);
            Arrays.fill(this.buffers, this.buffersSize, this.buffersSize + leftTrim, null);
        }
        return false;
    }

    @Override
    public byte get() {
        long location = this.locateBufferPosition(this.position++);
        return this.bufferGet(location);
    }

    @Override
    public ByteBuffersBuffer put(byte b) {
        long location = this.locateBufferPosition(this.position++);
        return this.bufferPut(location, b);
    }

    @Override
    public byte get(int index) {
        long location = this.locateBufferPosition(index);
        return this.bufferGet(location);
    }

    @Override
    public ByteBuffersBuffer put(int index, byte b) {
        long location = this.locateBufferPosition(index);
        return this.bufferPut(location, b);
    }

    @Override
    public ByteBuffersBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public ByteBuffersBuffer get(byte[] dst, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        long location = this.locateBufferPosition(this.position);
        int bufferIdx = ByteBuffersBuffer.getBufferIndex(location);
        ByteBuffer buffer = this.buffers[bufferIdx];
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            BufferUtils.get(buffer, dst, offset, bytesToCopy);
            buffer.position(oldPos);
            bufferPosition += bytesToCopy - 1;
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public ByteBuffersBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public ByteBuffersBuffer put(byte[] src, int offset, int length) {
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        long location = this.locateBufferPosition(this.position);
        int bufferIdx = ByteBuffersBuffer.getBufferIndex(location);
        ByteBuffer buffer = this.buffers[bufferIdx];
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            BufferUtils.put(src, offset, bytesToCopy, buffer);
            buffer.position(oldPos);
            bufferPosition += bytesToCopy - 1;
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public char getChar() {
        int ch1 = this.get() & 0xFF;
        int ch2 = this.get() & 0xFF;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public ByteBuffersBuffer putChar(char value) {
        this.put((byte)(value >>> 8));
        this.put((byte)(value & 0xFF));
        return this;
    }

    @Override
    public char getChar(int index) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 2) {
            return buffer.getChar(bufferPosition);
        }
        int ch1 = buffer.get(bufferPosition) & 0xFF;
        location = this.incLocation(location);
        int ch2 = this.bufferGet(location) & 0xFF;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public ByteBuffersBuffer putChar(int index, char value) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 2) {
            buffer.putChar(bufferPosition, value);
        } else {
            buffer.put(bufferPosition, (byte)(value >>> 8));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value & 0xFF));
        }
        return this;
    }

    @Override
    public short getShort() {
        byte v1 = this.get();
        byte v2 = this.get();
        short shortValue = (short)((v1 & 0xFF) << 8 | v2 & 0xFF);
        return shortValue;
    }

    @Override
    public ByteBuffersBuffer putShort(short value) {
        this.put((byte)(value >>> 8));
        this.put((byte)(value & 0xFF));
        return this;
    }

    @Override
    public short getShort(int index) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 2) {
            return buffer.getShort(bufferPosition);
        }
        int ch1 = buffer.get(bufferPosition) & 0xFF;
        location = this.incLocation(location);
        int ch2 = this.bufferGet(location) & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public ByteBuffersBuffer putShort(int index, short value) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 2) {
            buffer.putShort(bufferPosition, value);
        } else {
            buffer.put(bufferPosition, (byte)(value >>> 8));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value & 0xFF));
        }
        return this;
    }

    @Override
    public int getInt() {
        short v1 = this.getShort();
        short v2 = this.getShort();
        int intValue = (v1 & 0xFFFF) << 16 | v2 & 0xFFFF;
        return intValue;
    }

    @Override
    public ByteBuffersBuffer putInt(int value) {
        this.put((byte)(value >>> 24 & 0xFF));
        this.put((byte)(value >>> 16 & 0xFF));
        this.put((byte)(value >>> 8 & 0xFF));
        this.put((byte)(value >>> 0 & 0xFF));
        return this;
    }

    @Override
    public int getInt(int index) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 4) {
            return buffer.getInt(bufferPosition);
        }
        int ch1 = buffer.get(bufferPosition) & 0xFF;
        location = this.incLocation(location);
        int ch2 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch3 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch4 = this.bufferGet(location) & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public ByteBuffersBuffer putInt(int index, int value) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 4) {
            buffer.putInt(bufferPosition, value);
        } else {
            buffer.put(bufferPosition, (byte)(value >>> 24 & 0xFF));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 16 & 0xFF));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 8 & 0xFF));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 0 & 0xFF));
        }
        return this;
    }

    @Override
    public long getLong() {
        int v1 = this.getInt();
        int v2 = this.getInt();
        long longValue = ((long)v1 & 0xFFFFFFFFL) << 32 | (long)v2 & 0xFFFFFFFFL;
        return longValue;
    }

    @Override
    public ByteBuffersBuffer putLong(long value) {
        this.put((byte)(value >>> 56 & 0xFFL));
        this.put((byte)(value >>> 48 & 0xFFL));
        this.put((byte)(value >>> 40 & 0xFFL));
        this.put((byte)(value >>> 32 & 0xFFL));
        this.put((byte)(value >>> 24 & 0xFFL));
        this.put((byte)(value >>> 16 & 0xFFL));
        this.put((byte)(value >>> 8 & 0xFFL));
        this.put((byte)(value >>> 0 & 0xFFL));
        return this;
    }

    @Override
    public long getLong(int index) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 8) {
            return buffer.getLong(bufferPosition);
        }
        byte ch1 = buffer.get(bufferPosition);
        location = this.incLocation(location);
        int ch2 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch3 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch4 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch5 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch6 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch7 = this.bufferGet(location) & 0xFF;
        location = this.incLocation(location);
        int ch8 = this.bufferGet(location) & 0xFF;
        return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + (long)(ch6 << 16) + (long)(ch7 << 8) + (long)(ch8 << 0);
    }

    @Override
    public ByteBuffersBuffer putLong(int index, long value) {
        long location = this.locateBufferPosition(index);
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        if (buffer.limit() - bufferPosition >= 8) {
            buffer.putLong(bufferPosition, value);
        } else {
            buffer.put(bufferPosition, (byte)(value >>> 56 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 48 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 40 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 32 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 24 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 16 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 8 & 0xFFL));
            location = this.incLocation(location);
            this.bufferPut(location, (byte)(value >>> 0 & 0xFFL));
        }
        return this;
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public ByteBuffersBuffer putFloat(float value) {
        return this.putInt(Float.floatToIntBits(value));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public ByteBuffersBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToIntBits(value));
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public ByteBuffersBuffer putDouble(double value) {
        return this.putLong(Double.doubleToLongBits(value));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public ByteBuffersBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public int compareTo(Buffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBuffersBuffer (" + System.identityHashCode(this) + ") [");
        sb.append("pos=").append(this.position);
        sb.append(" lim=").append(this.limit);
        sb.append(" cap=").append(this.capacity);
        sb.append(" bufferSize=").append(this.buffersSize);
        sb.append(" buffers=" + Arrays.toString(this.buffers));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(null, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset, int position, int limit) {
        ByteBuffer limBuffer;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        long posLocation = this.locateBufferPosition(position);
        long limLocation = this.locateBufferLimit(limit);
        ByteBuffer posBuffer = this.buffers[ByteBuffersBuffer.getBufferIndex(posLocation)];
        if (posBuffer == (limBuffer = this.buffers[ByteBuffersBuffer.getBufferIndex(limLocation)])) {
            return BufferUtils.toStringContent(posBuffer, charset, ByteBuffersBuffer.getBufferPosition(posLocation), ByteBuffersBuffer.getBufferPosition(limLocation));
        }
        byte[] tmpBuffer = new byte[limit - position];
        int oldPosition = this.position;
        int oldLimit = this.limit;
        this.setPosLim(position, limit);
        this.get(tmpBuffer);
        this.setPosLim(oldPosition, oldLimit);
        return new String(tmpBuffer, charset);
    }

    private void removeBuffers() {
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
        this.buffersSize = 0;
        Arrays.fill(this.buffers, null);
        this.resetLastLocation();
    }

    private long locateBufferPosition(int position) {
        if (this.buffersSize == 0) {
            return -1L;
        }
        if (this.lastLocatedPosition != -1) {
            int diff = position - this.lastLocatedPosition;
            if (diff > 0) {
                this.lastLocatedInfo = this.moveForward(this.lastLocatedInfo, diff);
                this.lastLocatedPosition = position;
            } else if (diff < 0) {
                this.lastLocatedInfo = this.moveBack(this.lastLocatedInfo, -diff);
                this.lastLocatedPosition = position;
            }
            return this.lastLocatedInfo;
        }
        this.lastLocatedInfo = this.moveForward(this.buffers[0].position(), position);
        this.lastLocatedPosition = position;
        return this.lastLocatedInfo;
    }

    private long moveForward(long currentLocation, int steps) {
        ByteBuffer buffer;
        int bufferIdx = ByteBuffersBuffer.getBufferIndex(currentLocation);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(currentLocation);
        if (bufferPosition + steps < (buffer = this.buffers[bufferIdx]).limit()) {
            return ByteBuffersBuffer.makeLocation(bufferIdx, bufferPosition + steps);
        }
        steps -= buffer.limit() - bufferPosition;
        for (int i = ++bufferIdx; i < this.buffersSize; ++i) {
            buffer = this.buffers[i];
            if (steps < buffer.remaining()) {
                return ByteBuffersBuffer.makeLocation(i, buffer.position() + steps);
            }
            steps -= buffer.remaining();
        }
        if (steps == 0) {
            return ByteBuffersBuffer.makeLocation(this.buffersSize - 1, this.buffers[this.buffersSize - 1].limit());
        }
        throw new IndexOutOfBoundsException("Position " + this.position + " is out of bounds");
    }

    private long moveBack(long currentLocation, int steps) {
        ByteBuffer buffer;
        int bufferIdx = ByteBuffersBuffer.getBufferIndex(currentLocation);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(currentLocation);
        if (bufferPosition - steps >= (buffer = this.buffers[bufferIdx]).position()) {
            return ByteBuffersBuffer.makeLocation(bufferIdx, bufferPosition - steps);
        }
        steps -= bufferPosition - buffer.position();
        for (int i = --bufferIdx; i >= 0; --i) {
            buffer = this.buffers[i];
            if (steps <= buffer.remaining()) {
                return ByteBuffersBuffer.makeLocation(i, buffer.limit() - steps);
            }
            steps -= buffer.remaining();
        }
        throw new IndexOutOfBoundsException("Position " + this.position + " is out of bounds");
    }

    public long locateBufferLimit(int limit) {
        if (this.buffersSize == 0) {
            return -1L;
        }
        ByteBuffer buffer = this.buffers[0];
        int currentOffset = buffer.remaining();
        if (limit <= currentOffset) {
            return limit + buffer.position();
        }
        for (int i = 1; i < this.buffersSize; ++i) {
            buffer = this.buffers[i];
            int newOffset = currentOffset + buffer.remaining();
            if (limit <= newOffset) {
                return ByteBuffersBuffer.makeLocation(i, buffer.position() + limit - currentOffset);
            }
            currentOffset = newOffset;
        }
        throw new IndexOutOfBoundsException("Limit " + limit + " is out of bounds");
    }

    private long incLocation(long location) {
        ByteBuffer buffer;
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        if (bufferPosition + 1 < (buffer = this.buffers[bufferIndex]).limit()) {
            return location + 1L;
        }
        for (int i = bufferIndex + 1; i < this.buffersSize; ++i) {
            buffer = this.buffers[bufferIndex];
            if (!buffer.hasRemaining()) continue;
            return ByteBuffersBuffer.makeLocation(i, buffer.position());
        }
        throw new IndexOutOfBoundsException();
    }

    private byte bufferGet(long location) {
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        return buffer.get(bufferPosition);
    }

    private ByteBuffersBuffer bufferPut(long location, byte value) {
        int bufferIndex = ByteBuffersBuffer.getBufferIndex(location);
        int bufferPosition = ByteBuffersBuffer.getBufferPosition(location);
        ByteBuffer buffer = this.buffers[bufferIndex];
        buffer.put(bufferPosition, value);
        return this;
    }

    private static int getBufferIndex(long bufferLocation) {
        return (int)(bufferLocation >>> 32);
    }

    private static int getBufferPosition(long bufferLocation) {
        return (int)(bufferLocation & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long makeLocation(int bufferIndex, int bufferPosition) {
        return (long)bufferIndex << 32 | (long)bufferPosition;
    }

    private void setPosLim(int position, int limit) {
        if (position > limit) {
            throw new IllegalArgumentException("Position exceeds a limit: " + position + ">" + limit);
        }
        this.position = position;
        this.limit = limit;
    }

    private int calcCapacity() {
        int currentCapacity = 0;
        for (int i = 0; i < this.buffersSize; ++i) {
            currentCapacity += this.buffers[i].remaining();
        }
        return currentCapacity;
    }

    private void resetLastLocation() {
        this.lastLocatedPosition = -1;
        this.lastLocatedInfo = -1L;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteBuffersBuffer) {
            ByteBuffersBuffer that = (ByteBuffersBuffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }
}

