/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.FailureDetection;
import com.sun.enterprise.config.serverbeans.GroupManagementService;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class GMSConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(GMSConfigUpgrade.class, (String)"javax.org.glassfish.gms");
    @Inject
    Clusters clusters;
    @Inject
    Configs configs;

    public void postConstruct() {
        this.upgradeClusterElements();
        this.upgradeGroupManagementServiceElements();
    }

    private void upgradeClusterElements() {
        try {
            List clusterList = this.clusters.getCluster();
            for (Cluster cl : clusterList) {
                ConfigSupport.apply(new ClusterConfigCode(), cl);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "gmsupgrade.failed", e);
            throw new RuntimeException(e);
        }
    }

    private void upgradeGroupManagementServiceElements() {
        try {
            List lconfigs = this.configs.getConfig();
            for (Config c : lconfigs) {
                ConfigSupport.apply(new GroupManagementServiceConfigCode(), c);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "gmsupgrade.failed", t);
            throw new RuntimeException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupManagementServiceConfigCode
    implements SingleConfigCode<Config> {
        private GroupManagementServiceConfigCode() {
        }

        @Override
        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            Property prop;
            GroupManagementService gms = config.getGroupManagementService();
            Transaction t = Transaction.getTransaction(config);
            gms = t.enroll(gms);
            String value = gms.getPingProtocolTimeoutInMillis();
            if (value != null) {
                gms.setGroupDiscoveryTimeoutInMillis(value);
                gms.setPingProtocolTimeoutInMillis(null);
            }
            FailureDetection fd = gms.getFailureDetection();
            fd = t.enroll(fd);
            value = gms.getFdProtocolTimeoutInMillis();
            if (value != null) {
                fd.setHeartbeatFrequencyInMillis(value);
                gms.setFdProtocolTimeoutInMillis(null);
            }
            if ((value = gms.getFdProtocolMaxTries()) != null) {
                fd.setMaxMissedHeartbeats(value);
                gms.setFdProtocolMaxTries(null);
            }
            if ((value = gms.getVsProtocolTimeoutInMillis()) != null) {
                fd.setVerifyFailureWaittimeInMillis(value);
                gms.setVsProtocolTimeoutInMillis(null);
            }
            if ((prop = gms.getProperty("failure-detection-tcp-retransmit-timeout")) != null && prop.getValue() != null) {
                fd.setVerifyFailureConnectTimeoutInMillis(prop.getValue().trim());
                List props = gms.getProperty();
                props.remove(prop);
            }
            if (gms.getMergeProtocolMinIntervalInMillis() != null) {
                gms.setMergeProtocolMinIntervalInMillis(null);
            }
            if (gms.getMergeProtocolMaxIntervalInMillis() != null) {
                gms.setMergeProtocolMaxIntervalInMillis(null);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterConfigCode
    implements SingleConfigCode<Cluster> {
        private ClusterConfigCode() {
        }

        @Override
        public Object run(Cluster cluster) throws PropertyVetoException, TransactionFailure {
            Property prop;
            String value = cluster.getHeartbeatEnabled();
            if (value != null) {
                cluster.setGmsEnabled(value);
                cluster.setHeartbeatEnabled(null);
            }
            if ((value = cluster.getHeartbeatAddress()) != null) {
                cluster.setGmsMulticastAddress(value);
                cluster.setHeartbeatAddress(null);
            }
            if ((value = cluster.getHeartbeatPort()) != null) {
                cluster.setGmsMulticastPort(value);
                cluster.setHeartbeatPort(null);
            }
            if ((prop = cluster.getProperty("gms-bind-interface-address")) != null && prop.getValue() != null) {
                cluster.setGmsBindInterfaceAddress(prop.getValue());
                List props = cluster.getProperty();
                props.remove(prop);
            } else {
                value = cluster.getGmsBindInterfaceAddress();
                if (value == null) {
                    cluster.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", cluster.getName()));
                }
            }
            return cluster;
        }
    }
}

