/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="delete-instance")
@I18n(value="delete.instance")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class DeleteInstanceCommand
implements AdminCommand,
PostConstruct {
    private static final String DEFAULT_NODE = "localhost";
    private static final String LOCAL_HOST = "localhost";
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Param(name="instance_name", primary=true)
    private String instanceName;
    private Server instance;
    private String noderef;
    private String nodedir;
    private String installdir;
    private Logger logger;
    private AdminCommandContext ctx;
    private RemoteInstanceCommandHelper helper;
    private RemoteConnectHelper rch;
    private String instanceHost;
    private String dasHost;
    private int dasPort;
    private Node theNode = null;
    private StringBuilder humanVersionOfCommand = new StringBuilder();

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        String msg = "";
        boolean fsfailure = false;
        boolean configfailure = false;
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.instanceHost = this.instance.getAdminHost();
        this.dasPort = this.helper.getAdminPort("server");
        this.dasHost = System.getProperty("com.sun.aas.hostName");
        if (this.instance.isRunning()) {
            msg = Strings.get("instance.shutdown", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.noderef = this.helper.getNode(this.instance);
        if (!StringUtils.ok((String)this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            fsfailure = true;
        } else {
            this.theNode = this.nodes.getNode(this.noderef);
            if (this.theNode == null) {
                msg = Strings.get("noSuchNode", this.noderef);
                fsfailure = true;
            }
        }
        if (!fsfailure) {
            this.nodedir = this.theNode.getNodeDir();
            this.installdir = this.theNode.getInstallDir();
            try {
                this.deleteInstanceFilesystem();
            }
            catch (IOException ex) {
                msg = ex.getMessage();
                fsfailure = true;
            }
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_unregister-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.instanceName);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            configfailure = true;
            msg = fsfailure ? msg + NL + report.getMessage() : report.getMessage();
        }
        if (configfailure && fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.failed", this.instanceName, this.instanceHost);
        } else if (configfailure && !fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.config.failed", this.instanceName, this.instanceHost);
        } else if (!configfailure && fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.filesystem.failed", this.instanceName, this.noderef, this.instanceHost, this.humanVersionOfCommand);
        }
        if (configfailure || fsfailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }

    private void deleteInstanceRemote() throws IOException {
        StringBuilder output = new StringBuilder();
        ParameterMap map = new ParameterMap();
        map.add((Object)"--node", (Object)this.noderef);
        if (this.nodedir != null) {
            map.add((Object)"--nodedir", (Object)this.nodedir);
            this.humanVersionOfCommand.append(" --nodedir " + this.nodedir);
        }
        map.add((Object)"DEFAULT", (Object)this.instanceName);
        this.humanVersionOfCommand.append(" " + this.instanceName);
        try {
            int status = this.rch.runCommand(this.noderef, "_delete-instance-filesystem", map, output);
            if (output.length() > 0) {
                this.logger.info(output.toString());
            }
            if (status != 0) {
                String msg2 = Strings.get("node.command.failed", this.noderef, this.instanceHost, output.toString(), this.rch.getLastCommandRun());
                this.logger.warning(msg2);
                throw new IOException(msg2);
            }
        }
        catch (SSHCommandExecutionException ec) {
            String msg2 = Strings.get("node.ssh.bad.connect", this.noderef, this.instanceHost, ec.getMessage());
            String msg1 = Strings.get("node.command.failed.ssh.details", this.noderef, this.instanceHost, ec.getCommandRun(), ec.getMessage(), ec.getSSHSettings());
            this.logger.warning(msg1);
            throw new IOException(msg2, ec);
        }
    }

    private void deleteInstanceFilesystem() throws IOException {
        block8: {
            this.rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, this.dasHost, this.dasPort);
            this.humanVersionOfCommand.append("asadmin --host " + this.dasHost + " --port " + this.dasPort + " delete-local-instance " + " --node " + this.noderef);
            if (this.rch.isLocalhost(this.nodes.getNode(this.noderef))) {
                LocalAdminCommand lac = null;
                if (this.nodedir == null) {
                    lac = new LocalAdminCommand("_delete-instance-filesystem", new String[]{"--node", this.noderef, this.instanceName});
                } else {
                    lac = new LocalAdminCommand("_delete-instance-filesystem", new String[]{"--node", this.noderef, "--nodedir", this.nodedir, this.instanceName});
                    this.humanVersionOfCommand.append("--nodedir " + this.nodedir);
                }
                this.humanVersionOfCommand.append(" " + this.instanceName);
                String msg = Strings.get("deletingInstance", this.instanceName, "localhost");
                this.logger.info(msg);
                try {
                    int status = lac.execute();
                    if (status != 0) {
                        msg = Strings.get("nonzero.status", "asadmin _delete-instance-filesystem", "localhost");
                        this.logger.warning(msg);
                        throw new IOException(msg);
                    }
                    break block8;
                }
                catch (ProcessManagerException ex) {
                    String msg2 = Strings.get("node.command.failed", this.noderef, this.instanceHost, "_delete-instance-filesystem", ex.getMessage());
                    throw new IOException(msg2, ex);
                }
            }
            if (this.rch.isRemoteConnectRequired(this.noderef)) {
                String msg = Strings.get("deletingInstance", this.instanceName, this.noderef);
                this.logger.info(msg);
                this.deleteInstanceRemote();
            } else {
                String msg2 = Strings.get("node.not.ssh", this.noderef, this.instanceHost);
                this.logger.warning(msg2);
                throw new IOException(msg2);
            }
        }
    }
}

