/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="start-instance")
@CommandLock(value=CommandLock.LockType.NONE)
@Scoped(value=PerLookup.class)
@I18n(value="start.instance.command")
public class StartInstanceCommand
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Inject
    private ServerEnvironment env;
    @Param(optional=true, primary=true)
    private String instanceName;
    @Param(optional=true)
    private boolean fullsync;
    @Param(optional=true, defaultValue="false")
    private boolean nosync;
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    @Param(optional=true, obsolete=true)
    private String setenv;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private AdminCommandContext ctx;
    private String noderef;
    private String nodedir;
    private String nodeHost;
    private Server instance;
    private String installDir = null;
    private static final String NL = System.getProperty("line.separator");

    public void execute(AdminCommandContext context) {
        String s;
        this.logger = context.getLogger();
        this.ctx = context;
        ActionReport report = this.ctx.getActionReport();
        String msg = "";
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (!StringUtils.ok((String)this.instanceName)) {
            msg = Strings.get("start.instance.noInstanceName");
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        if (this.instance.isRunning()) {
            msg = Strings.get("start.instance.already.running", this.instanceName);
            this.logger.info(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        this.noderef = this.helper.getNode(this.instance);
        if (!StringUtils.ok((String)this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        if (this.nodes != null) {
            Node n = this.nodes.getNode(this.noderef);
            if (n != null) {
                this.nodedir = n.getNodeDir();
                this.nodeHost = n.getNodeHost();
                this.installDir = n.getInstallDir();
            } else {
                msg = Strings.get("missingNode", this.noderef);
                this.logger.severe(msg);
                report.setMessage(msg);
                return;
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.env.isDas()) {
            this.startInstance();
        } else {
            msg = Strings.get("start.instance.notAnInstanceOrDas", this.env.getRuntimeType().toString());
            this.logger.severe(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS && (s = this.pollForLife()) != null) {
            report.setMessage(s);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    private void startLocalInstance() {
        LocalAdminCommand lac = null;
        ArrayList<String> command = new ArrayList<String>();
        ActionReport report = this.ctx.getActionReport();
        command.add("--node");
        command.add(this.noderef);
        if (StringUtils.ok((String)this.nodedir)) {
            command.add("--nodedir");
            command.add(this.nodedir);
        }
        if (this.fullsync) {
            command.add("--fullsync");
        }
        if (this.nosync) {
            command.add("--nosync");
        }
        if (this.debug) {
            command.add("--debug");
        }
        command.add(this.instanceName);
        StringBuilder humanVersionOfCommand = new StringBuilder();
        for (String s : command) {
            humanVersionOfCommand.append(s);
            humanVersionOfCommand.append(" ");
        }
        String[] commandArray = new String[command.size()];
        lac = new LocalAdminCommand("start-local-instance", command.toArray(commandArray));
        try {
            lac.waitForReaderThreads(false);
            int status = lac.execute();
            if (status != 0) {
                String msg = Strings.get("nonzero.status", humanVersionOfCommand, "localhost");
                this.logger.warning(msg);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        catch (ProcessManagerException ex) {
            String msg = Strings.get("start.instance.failed", this.instanceName, this.noderef, this.nodeHost);
            this.logger.warning(msg);
            String msg2 = Strings.get("node.command.failed", this.noderef, this.nodeHost, humanVersionOfCommand, ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg + NL + msg2);
        }
    }

    private void startInstance() {
        int dasPort = this.helper.getAdminPort("server");
        String dasHost = System.getProperty("com.sun.aas.hostName");
        RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, dasHost, dasPort);
        ActionReport report = this.ctx.getActionReport();
        StringBuilder humanVersionOfCommand = new StringBuilder("asadmin start-local-instance");
        if (rch.isLocalhost(this.nodes.getNode(this.noderef))) {
            this.startLocalInstance();
        } else if (rch.isRemoteConnectRequired(this.noderef)) {
            StringBuilder output = new StringBuilder();
            ParameterMap map = new ParameterMap();
            map.set((Object)"DEFAULT", (Object)this.instanceName);
            map.set((Object)"--node", (Object)this.noderef);
            humanVersionOfCommand.append(" --node " + this.noderef);
            if (this.nodedir != null) {
                map.set((Object)"--nodedir", (Object)this.nodedir);
                humanVersionOfCommand.append(" --nodedir ");
            }
            if (this.fullsync) {
                map.set((Object)"--fullsync", (Object)"true");
                humanVersionOfCommand.append(" --fullsync ");
            }
            if (this.nosync) {
                map.set((Object)"--nosync", (Object)"true");
                humanVersionOfCommand.append(" --nosync ");
            }
            if (this.debug) {
                map.set((Object)"--debug", (Object)"true");
                humanVersionOfCommand.append(" --debug ");
            }
            humanVersionOfCommand.append(" " + this.instanceName);
            try {
                int status = rch.runCommand(this.noderef, "start-local-instance", map, output);
                if (output.length() > 0) {
                    this.logger.info(output.toString());
                }
                if (status != 0) {
                    String msg1 = Strings.get("node.command.failed", this.noderef, this.nodeHost, output.toString(), rch.getLastCommandRun());
                    this.logger.warning(msg1);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg1);
                }
            }
            catch (SSHCommandExecutionException ec) {
                String msg1 = Strings.get("start.instance.failed", this.instanceName, this.noderef, this.nodeHost);
                String msg2 = Strings.get("node.ssh.bad.connect", this.noderef, this.nodeHost, ec.getMessage());
                String msg3 = Strings.get("node.ssh.tocomplete", this.nodeHost, this.installDir, humanVersionOfCommand);
                report.setMessage(msg1 + " " + msg2 + NL + NL + msg3);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                msg1 = Strings.get("node.command.failed.ssh.details", this.noderef, this.nodeHost, ec.getCommandRun(), ec.getMessage(), ec.getSSHSettings());
                this.logger.warning(msg1);
            }
        } else {
            humanVersionOfCommand.append(" " + this.instanceName);
            String msg1 = Strings.get("start.instance.failed", this.instanceName, this.noderef, this.nodeHost);
            this.logger.warning(msg1);
            String msg2 = Strings.get("node.not.ssh", this.noderef, this.nodeHost);
            this.logger.warning(msg2);
            String msg3 = Strings.get("node.ssh.tocomplete", this.nodeHost, this.installDir, humanVersionOfCommand);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg1 + " " + msg2 + NL + NL + msg3);
        }
    }

    private String pollForLife() {
        int counter = 0;
        while (++counter < 240) {
            if (this.instance.isRunning()) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return Strings.get("start.instance.timeout", this.instanceName);
    }
}

