/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.ha.store.spi.StorableMap;
import org.glassfish.web.ha.session.management.SessionAttributeMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeMetadata
implements Storeable {
    private long version;
    private long maxInactiveInterval;
    private long lastAccessTime;
    private byte[] state;
    private String stringExtraParam;
    private Map<String, SessionAttributeMetadata> attributesMap = new HashMap<String, SessionAttributeMetadata>();
    private transient Collection<SessionAttributeMetadata> entries;
    private transient Map<String, byte[]> storeableEntryMap;
    private transient Set<String> _dirtyAttributeNames = new HashSet<String>();
    private static transient String[] _attributeNames = new String[]{"trunkState", "stringExtraParam", "sessionAttributes"};
    private static transient Set<String> saveALL = new HashSet<String>();
    private static transient Set<String> saveEP = new HashSet<String>();
    private boolean[] dirtyBits = new boolean[]{false, false, false};

    public CompositeMetadata() {
    }

    public CompositeMetadata(long version, long lastAccessTime, long maxInactiveInterval, Collection<SessionAttributeMetadata> entries, byte[] state, String stringExtraParam) {
        this.version = version;
        this.lastAccessTime = lastAccessTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.entries = entries;
        this.dirtyBits[2] = true;
        if (state != null) {
            this.setState(state);
        } else {
            this.dirtyBits[0] = false;
        }
        this.setStringExtraParam(stringExtraParam);
    }

    public byte[] getState() {
        return this.state;
    }

    public void setState(byte[] state) {
        this.state = state;
        this.dirtyBits[0] = true;
    }

    public String getStringExtraParam() {
        return this.stringExtraParam;
    }

    public void setStringExtraParam(String stringExtraParam) {
        this.stringExtraParam = stringExtraParam;
        this.dirtyBits[1] = true;
    }

    public Map<String, byte[]> getSessionAttributes() {
        return this.storeableEntryMap == null ? new SessionAttributesMapImpl(this.entries) : this.storeableEntryMap;
    }

    public Collection<SessionAttributeMetadata> getEntries() {
        return this.attributesMap.values();
    }

    public long getVersion() {
        return 0L;
    }

    public long _storeable_getVersion() {
        return this.version;
    }

    public void _storeable_setVersion(long version) {
        this.version = version;
    }

    public long _storeable_getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void _storeable_setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long _storeable_getMaxIdleTime() {
        return this.maxInactiveInterval;
    }

    public void _storeable_setMaxIdleTime(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String[] _storeable_getAttributeNames() {
        return _attributeNames;
    }

    public boolean[] _storeable_getDirtyStatus() {
        return this.dirtyBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_writeState(OutputStream os) throws IOException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(os);
            dos.writeLong(this.version);
            dos.writeLong(this.lastAccessTime);
            dos.writeLong(this.maxInactiveInterval);
            for (int i = 0; i < this.dirtyBits.length; ++i) {
                dos.writeBoolean(this.dirtyBits[i]);
            }
            if (this.dirtyBits[0]) {
                dos.writeInt(this.state == null ? 0 : this.state.length);
                if (this.state != null) {
                    dos.write(this.state);
                }
            }
            if (this.dirtyBits[1]) {
                if (this.stringExtraParam == null) {
                    dos.writeInt(0);
                } else {
                    byte[] sd = this.stringExtraParam.getBytes();
                    dos.writeInt(sd.length);
                    dos.write(sd);
                }
            }
            if (this.dirtyBits[2]) {
                dos.writeInt(this.entries.size());
                for (SessionAttributeMetadata attr : this.entries) {
                    byte[] opNameInBytes = attr.getOperation().toString().getBytes();
                    dos.writeInt(opNameInBytes.length);
                    dos.write(opNameInBytes);
                    String attrName = attr.getAttributeName();
                    if (attrName == null) {
                        dos.writeInt(0);
                        continue;
                    }
                    byte[] attrNameData = attrName.getBytes();
                    dos.writeInt(attrNameData.length);
                    dos.write(attrNameData);
                    if (attr.getOperation() != SessionAttributeMetadata.Operation.ADD && attr.getOperation() != SessionAttributeMetadata.Operation.UPDATE) continue;
                    System.out.println("CompositeMetadata:write " + (Object)((Object)attr.getOperation()) + " Attribute name " + attrName);
                    byte[] attrData = attr.getState();
                    if (attrData == null) {
                        dos.writeInt(0);
                        continue;
                    }
                    dos.writeInt(attrData.length);
                    dos.write(attrData);
                }
            }
        }
        finally {
            try {
                dos.flush();
                dos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_readState(InputStream is) throws IOException {
        DataInputStream dis = null;
        try {
            int len;
            dis = new DataInputStream(is);
            this.version = dis.readLong();
            this.lastAccessTime = dis.readLong();
            this.maxInactiveInterval = dis.readLong();
            this.dirtyBits = new boolean[]{true, true, true};
            boolean[] dirtyFlags = new boolean[3];
            for (int i = 0; i < dirtyFlags.length; ++i) {
                dirtyFlags[i] = dis.readBoolean();
                System.out.println("_storeable_readState.DirtyFlag [" + i + "] is " + dirtyFlags[i]);
            }
            if (dirtyFlags[0] && (len = dis.readInt()) > 0) {
                this.state = new byte[len];
                dis.read(this.state);
            }
            if (dirtyFlags[1] && (len = dis.readInt()) > 0) {
                byte[] sd = new byte[len];
                dis.read(sd);
                this.stringExtraParam = new String(sd);
            }
            if (dirtyFlags[2]) {
                int entryCount = dis.readInt();
                block12: for (int i = 0; i < entryCount; ++i) {
                    int opNameLen = dis.readInt();
                    byte[] opnameData = new byte[opNameLen];
                    dis.read(opnameData);
                    String opName = new String(opnameData);
                    int attrNameLen = dis.readInt();
                    if (attrNameLen <= 0) continue;
                    byte[] sd = new byte[attrNameLen];
                    dis.read(sd);
                    String attrName = new String(sd);
                    SessionAttributeMetadata.Operation smdOpcode = SessionAttributeMetadata.Operation.valueOf(opName);
                    switch (smdOpcode) {
                        case ADD: 
                        case UPDATE: {
                            int dataLen = dis.readInt();
                            byte[] attrData = new byte[dataLen];
                            dis.read(attrData);
                            this.attributesMap.put(attrName, new SessionAttributeMetadata(attrName, smdOpcode, attrData));
                            System.out.println("CompositeMetadata: " + (Object)((Object)smdOpcode) + " Attribute name " + attrName);
                            continue block12;
                        }
                        case DELETE: {
                            this.attributesMap.remove(attrName);
                            System.out.println("CompositeMetadata: DELETE " + (Object)((Object)smdOpcode) + " Attribute name " + attrName);
                        }
                    }
                }
            }
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        saveALL.add("state");
        saveALL.add("extraParam");
        saveEP.add("extraParam");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionAttributesMapImpl
    extends HashMap<String, byte[]>
    implements StorableMap<Object, byte[]> {
        Set<String> newKeys = new HashSet<String>();
        Set<String> modifiedKeys = new HashSet<String>();
        Set<String> deletedKeys = new HashSet<String>();
        Map<String, byte[]> map = new HashMap<String, byte[]>();

        SessionAttributesMapImpl() {
        }

        SessionAttributesMapImpl(Collection<SessionAttributeMetadata> attrs) {
            for (SessionAttributeMetadata attr : attrs) {
                super.put(attr.getAttributeName(), attr.getState());
                if (attr.getOperation() == SessionAttributeMetadata.Operation.ADD) {
                    this.newKeys.add(attr.getAttributeName());
                    continue;
                }
                if (attr.getOperation() == SessionAttributeMetadata.Operation.UPDATE) {
                    this.modifiedKeys.add(attr.getAttributeName());
                    continue;
                }
                this.deletedKeys.add(attr.getAttributeName());
            }
        }

        public Collection getDeletedKeys() {
            return this.deletedKeys;
        }

        public Collection getModifiedKeys() {
            return this.modifiedKeys;
        }

        public Collection getNewKeys() {
            return this.deletedKeys;
        }
    }
}

