/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.resolution.Resolvable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeSafeResolver<R extends Resolvable, T> {
    private final ConcurrentMap<Key<R>, Set<T>> resolved = new MapMaker().makeComputingMap(new ResolvableToBeanSet(this));
    private final Iterable<? extends T> allBeans;

    public TypeSafeResolver(Iterable<? extends T> allBeans) {
        this.allBeans = allBeans;
    }

    public void clear() {
        this.resolved.clear();
    }

    public Set<T> resolve(R resolvable) {
        return Collections.unmodifiableSet((Set)this.resolved.get(new Key((Resolvable)resolvable, null)));
    }

    private Set<T> findMatching(R resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean : this.allBeans) {
            if (!this.matches(resolvable, bean)) continue;
            result.add(bean);
        }
        return result;
    }

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract Set<T> sortResult(Set<T> var1);

    protected abstract boolean matches(R var1, T var2);

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved injection points: " + this.resolved.size() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvableToBeanSet<R extends Resolvable, T>
    implements Function<Key<R>, Set<T>> {
        private final TypeSafeResolver<R, T> resolver;

        private ResolvableToBeanSet(TypeSafeResolver<R, T> resolver) {
            this.resolver = resolver;
        }

        @Override
        public Set<T> apply(Key<R> from) {
            return this.resolver.sortResult(this.resolver.filterResult(((TypeSafeResolver)this.resolver).findMatching(from.getResolvable())));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key<R extends Resolvable> {
        private final R resolvable;

        private Key(R resolvable) {
            this.resolvable = resolvable;
        }

        public R getResolvable() {
            return this.resolvable;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return that.getResolvable().getClass().equals(this.getResolvable().getClass()) && that.getResolvable().isEqualTo((Resolvable)that.getResolvable());
            }
            return false;
        }

        public int hashCode() {
            return this.getResolvable().hashCode();
        }

        public String toString() {
            return this.getResolvable().toString();
        }

        /* synthetic */ Key(Resolvable x0, 1 x1) {
            this(x0);
        }
    }
}

