/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.serviceProvider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceLoader<S>
implements Iterable<S> {
    private static LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.UTIL);
    private static XLogger logX = LoggerFactory.loggerFactory().getXLogger(Category.UTIL);
    private static final String SERVICES = "META-INF/services";
    private final String serviceFile;
    private Class<S> expectedType;
    private final ClassLoader loader;
    private Set<S> providers;

    public static <S> DefaultServiceLoader<S> load(Class<S> service) {
        return DefaultServiceLoader.load(SERVICES, service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> DefaultServiceLoader<S> load(String directoryName, Class<S> service) {
        return DefaultServiceLoader.load(directoryName, service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> DefaultServiceLoader<S> load(String directoryName, Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new DefaultServiceLoader<S>(directoryName, service, loader);
    }

    public static <S> DefaultServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return DefaultServiceLoader.load(SERVICES, service, loader);
    }

    public static <S> DefaultServiceLoader<S> loadInstalled(Class<S> service) {
        throw new UnsupportedOperationException();
    }

    private DefaultServiceLoader(String prefix, Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = prefix + "/" + service.getName();
        this.expectedType = service;
    }

    public void reload() {
        this.providers = new HashSet<S>();
        for (URL serviceFile : this.loadServiceFiles()) {
            this.loadServiceFile(serviceFile);
        }
    }

    private List<URL> loadServiceFiles() {
        try {
            return new EnumerationList<URL>(this.loader.getResources(this.serviceFile));
        }
        catch (IOException e) {
            log.warn(UtilMessage.COULD_NOT_READ_SERVICES_LIST, this.serviceFile, e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadServiceFile(URL serviceFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(serviceFile.openStream(), "UTF-8"));
            String serviceClassName = null;
            while ((serviceClassName = reader.readLine()) != null) {
                if ((serviceClassName = this.trim(serviceClassName)).length() <= 0) continue;
                this.loadService(serviceClassName);
            }
            if (reader == null) return;
        }
        catch (IOException e) {
            try {
                logX.throwing(XLogger.Level.ERROR, e);
                throw new IllegalStateException(UtilMessage.COULD_NOT_READ_SERVICES_FILE, serviceFile);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn(UtilMessage.COULD_NOT_READ_SERVICES_FILE, serviceFile, e2);
                }
                throw throwable;
            }
        }
        try {
            reader.close();
            return;
        }
        catch (IOException e) {
            log.warn(UtilMessage.COULD_NOT_READ_SERVICES_FILE, serviceFile, e);
            return;
        }
    }

    private String trim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        return line.trim();
    }

    private void loadService(String serviceClassName) {
        Class<S> serviceClass = this.loadClass(serviceClassName);
        Object serviceInstance = null;
        if (serviceClass != null) {
            serviceInstance = this.prepareInstance(serviceClass);
        }
        if (serviceInstance != null) {
            this.providers.add(serviceInstance);
        }
    }

    private Class<? extends S> loadClass(String serviceClassName) {
        Class<?> clazz = null;
        Class<S> serviceClass = null;
        try {
            clazz = this.loader.loadClass(serviceClassName);
            serviceClass = clazz.asSubclass(this.expectedType);
        }
        catch (ClassNotFoundException e) {
            log.warn(UtilMessage.EXTENSION_CLASS_NOT_FOUND, serviceClassName);
        }
        catch (ClassCastException e) {
            log.warn(UtilMessage.DECLARED_EXTENSION_DOES_NOT_IMPLEMENT_EXTENSION, serviceClassName);
        }
        return serviceClass;
    }

    private S prepareInstance(Class<? extends S> serviceClass) {
        try {
            return (S)SecureReflections.ensureAccessible(SecureReflections.getDeclaredConstructor(serviceClass, new Class[0])).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.warn(UtilMessage.SECURITY_EXCEPTION_SCANNING, serviceClass.getName());
            return null;
        }
    }

    @Override
    public Iterator<S> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

