/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.MasterPassword;

public class RelativePathResolver {
    private static Logger _logger = null;
    private static RelativePathResolver _instance = null;
    private PasswordAdapter pwdAdapter = null;
    private static final String ALIAS_TOKEN = "ALIAS";
    private static final String ALIAS_DELIMITER = "=";
    private static MasterPassword masterPasswordHelper = null;

    protected static synchronized Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger(RelativePathResolver.class, (String)"javax.enterprise.system.util");
        }
        return _logger;
    }

    private static synchronized RelativePathResolver getInstance() {
        if (_instance == null) {
            _instance = new RelativePathResolver();
        }
        return _instance;
    }

    public static String unresolvePath(String path, String[] propNames) {
        return RelativePathResolver.getInstance().unresolve(path, propNames);
    }

    public static String resolvePath(String path) {
        return RelativePathResolver.getInstance().resolve(path);
    }

    public String unresolve(String path, String[] propNames) {
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
            for (int i = 0; i < propNames.length; ++i) {
                String propVal = this.getPropertyValue(propNames[i], true);
                if (propVal != null) {
                    int startIdx = path.indexOf(propVal = propVal.replace(File.separatorChar, '/'));
                    if (startIdx < 0) continue;
                    path = path.substring(0, startIdx) + "${" + propNames[i] + "}" + path.substring(startIdx + propVal.length());
                    continue;
                }
                RelativePathResolver.getLogger().log(Level.SEVERE, "enterprise_util.path_unresolver_missing_property", new Object[]{propNames[i], path});
            }
        }
        return path;
    }

    protected void fatalError(String message, String path) {
        RelativePathResolver.getLogger().log(Level.SEVERE, message, new Object[]{path});
        StringManagerBase sm = StringManagerBase.getStringManager((String)RelativePathResolver.getLogger().getResourceBundleName(), (ClassLoader)this.getClass().getClassLoader());
        throw new RuntimeException(sm.getString(message, (Object)path));
    }

    private void appendChar(char c, StringBuffer propName, StringBuffer result) {
        if (propName == null) {
            result.append(c);
        } else {
            propName.append(c);
        }
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1 && (propName = propName.substring(0, lastIdx)) != null) {
            aliasName = propName.trim();
        }
        return aliasName;
    }

    protected String getPropertyValue(String propName, boolean bIncludingEnvironmentVariables) {
        int idx2;
        int idx1;
        if (!bIncludingEnvironmentVariables) {
            return null;
        }
        String result = System.getProperty(propName);
        if (result == null && (idx1 = propName.indexOf(ALIAS_TOKEN)) >= 0 && (idx2 = propName.indexOf(ALIAS_DELIMITER, ALIAS_TOKEN.length())) > 0) {
            String aliasName = propName.substring(idx2 + 1).trim();
            try {
                if (this.pwdAdapter == null) {
                    this.pwdAdapter = masterPasswordHelper.getMasterPasswordAdapter();
                }
                result = this.pwdAdapter.getPasswordForAlias(aliasName);
            }
            catch (Exception ex) {
                RelativePathResolver.getLogger().log(Level.WARNING, "enterprise_util.path_resolver_alias_exception", new Object[]{ex, aliasName, propName});
                RelativePathResolver.getLogger().log(Level.FINE, "enterprise_util.path_resolver_alias_exception", ex);
            }
        }
        return result;
    }

    public String resolve(String path) {
        return this.resolve(path, true);
    }

    public String resolve(String path, boolean bIncludingEnvironmentVariables) {
        if (path == null) {
            return path;
        }
        int size = path.length();
        StringBuffer result = new StringBuffer(size);
        StringBuffer propName = null;
        boolean foundOne = false;
        block4: for (int i = 0; i < size; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '$': {
                    if (i < size - 1 && path.charAt(i + 1) == '{') {
                        foundOne = true;
                        ++i;
                        if (propName == null) {
                            propName = new StringBuffer();
                            continue block4;
                        }
                        this.fatalError("enterprise_util.path_resolver_missing_closing_delim", path);
                        return path;
                    }
                    this.appendChar(c, propName, result);
                    continue block4;
                }
                case '}': {
                    if (foundOne) {
                        if (propName != null) {
                            String propVal = this.getPropertyValue(propName.toString(), bIncludingEnvironmentVariables);
                            if (propVal != null) {
                                result.append(propVal.replace(File.separatorChar, '/'));
                            } else {
                                result.append("${" + propName + "}");
                            }
                            propName = null;
                            continue block4;
                        }
                        this.fatalError("enterprise_util.path_resolver_missing_starting_delim", path);
                        return path;
                    }
                    this.appendChar(c, propName, result);
                    continue block4;
                }
                default: {
                    this.appendChar(c, propName, result);
                }
            }
        }
        if (propName != null) {
            this.fatalError("enterprise_util.path_resolver_missing_closing_delim", path);
            return path;
        }
        return result.toString();
    }

    public boolean isResolvable(String path, boolean bIncludingEnvironmentVariables) {
        String resolved = this.resolve(path, bIncludingEnvironmentVariables);
        return resolved.indexOf("${") < 0;
    }

    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("unresolve")) {
            for (int i = 2; i < args.length; ++i) {
                String result = RelativePathResolver.unresolvePath(args[i], new String[]{args[1]});
                System.out.println(args[i] + " " + result + " " + RelativePathResolver.resolvePath(result));
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                System.out.println(args[i] + " " + RelativePathResolver.resolvePath(args[i]));
            }
        }
    }

    public static String getRealPasswordFromAlias(String at) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (at == null || RelativePathResolver.getAlias(at) == null) {
                return at;
            }
        }
        catch (Exception e) {
            return at;
        }
        String an = RelativePathResolver.getAlias(at);
        PasswordAdapter pa = masterPasswordHelper.getMasterPasswordAdapter();
        boolean exists = pa.aliasExists(an);
        if (!exists) {
            StringManager lsm = StringManager.getManager(RelativePathResolver.class);
            String msg = lsm.getString("no_such_alias", (Object)an, (Object)at);
            throw new IllegalArgumentException(msg);
        }
        String real = pa.getPasswordForAlias(an);
        return real;
    }

    static {
        masterPasswordHelper = Globals.getDefaultHabitat().getByContract(MasterPassword.class);
    }
}

