/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinPolicy {
    private static final Logger _logger = LogDomains.getLogger(RoundRobinPolicy.class, (String)"javax.enterprise.system.core.naming");
    private static Random rand = new Random();
    private List<ClusterInstanceInfo> endpointsList = new LinkedList<ClusterInstanceInfo>();
    private int sumOfAllWeights = 0;
    private static final int default_weight = 10;

    private static void warnLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.WARNING, fmt, args);
    }

    private static void infoLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.INFO, fmt, args);
    }

    private static void fineLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.FINE, fmt, args);
    }

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    public RoundRobinPolicy(String[] list) {
        this.setClusterInstanceInfo(list);
    }

    public final synchronized void setClusterInstanceInfo(List<ClusterInstanceInfo> list) {
        boolean isWeighted;
        this.sumOfAllWeights = 0;
        String policy = System.getProperty("com.sun.appserv.iiop.loadbalancingpolicy");
        if (policy == null) {
            policy = "ic-based";
        }
        if (policy.equals("ic-based-weighted")) {
            isWeighted = true;
        } else if (policy.equals("ic-based")) {
            isWeighted = false;
        } else {
            isWeighted = false;
            RoundRobinPolicy.warnLog("loadbalancing.policy.incorrect", new Object[0]);
        }
        RoundRobinPolicy.fineLog("isWeighted = {0}", isWeighted);
        ArrayList<ClusterInstanceInfo> newList = new ArrayList<ClusterInstanceInfo>();
        for (ClusterInstanceInfo endpoint : list) {
            ClusterInstanceInfo newEndpoint = isWeighted ? new ClusterInstanceInfo(endpoint.name(), endpoint.weight(), endpoint.endpoints()) : new ClusterInstanceInfo(endpoint.name(), 10, endpoint.endpoints());
            newList.add(newEndpoint);
            RoundRobinPolicy.infoLog("endpoint.weight after checking isWeight = {0}", endpoint.weight());
            this.sumOfAllWeights += newEndpoint.weight();
        }
        this.endpointsList = newList;
        RoundRobinPolicy.infoLog("sumOfAllWeights = {0}", this.sumOfAllWeights);
    }

    public final synchronized void setClusterInstanceInfo(String[] list) {
        String[] newList = null;
        newList = list != null && list.length > 0 ? this.getAddressPortList(list) : this.getEndpointForProviderURL(System.getProperty("java.naming.provider.url"));
        if (newList != null && newList.length > 0) {
            String[] new_list = this.randomize(newList);
            LinkedList<ClusterInstanceInfo> targetServerList = new LinkedList<ClusterInstanceInfo>();
            for (int i = 0; i < new_list.length; ++i) {
                if (!this.notDuplicate(new_list[i])) continue;
                targetServerList.add(this.makeClusterInstanceInfo(new_list[i], 10));
            }
            if (!targetServerList.isEmpty()) {
                targetServerList.addAll(this.endpointsList);
                this.setClusterInstanceInfo(targetServerList);
            }
        } else {
            RoundRobinPolicy.warnLog("no.endpoints", new Object[0]);
        }
    }

    private ClusterInstanceInfo makeClusterInstanceInfo(String str, int weight) {
        String[] host_port = str.split(":");
        String server_identifier = "";
        String type = "CLEAR_TEXT";
        SocketInfo socketInfo = new SocketInfo(type, host_port[0], Integer.parseInt(host_port[1]));
        ArrayList<SocketInfo> sil = new ArrayList<SocketInfo>(1);
        sil.add(socketInfo);
        ClusterInstanceInfo instanceInfo = new ClusterInstanceInfo(server_identifier, weight, sil);
        return instanceInfo;
    }

    private synchronized boolean notDuplicate(String str) {
        String[] host_port = str.split(":");
        for (ClusterInstanceInfo cinfo : this.endpointsList) {
            for (SocketInfo sinfo : cinfo.endpoints()) {
                if (!sinfo.host().equals(host_port[0]) && sinfo.port() != Integer.parseInt(host_port[1])) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getEndpointForProviderURL(String providerURLString) {
        String[] newList = null;
        if (providerURLString != null) {
            try {
                IiopUrl providerURL = new IiopUrl(providerURLString);
                newList = this.getAddressPortList(providerURL);
                RoundRobinPolicy.warnLog("no.endpoints.selected.provider", providerURLString);
            }
            catch (MalformedURLException me) {
                RoundRobinPolicy.warnLog("provider.exception", me.getMessage(), providerURLString);
            }
        }
        return newList;
    }

    private String[] randomize(String[] list) {
        String[] randomizedList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            int random;
            do {
                random = rand.nextInt(list.length);
                RoundRobinPolicy.fineLog("random ==> {0}", random);
            } while (list[random] == null);
            randomizedList[i] = list[random];
            RoundRobinPolicy.fineLog("randomisedList[{0}] ==> {1}", i, randomizedList[i]);
            list[random] = null;
        }
        return randomizedList;
    }

    public synchronized Object[] getNextRotation() {
        int lowerLimit = 0;
        int random = 0;
        RoundRobinPolicy.fineLog("RoundRobinPolicy.getNextRotation -> sumOfAllWeights = {0}", this.sumOfAllWeights);
        while (random == 0 && (random = rand.nextInt(this.sumOfAllWeights)) == 0) {
        }
        RoundRobinPolicy.fineLog("getNextRotation : random # = {0} sum of all weights = {1}", random, this.sumOfAllWeights);
        int i = 0;
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            int upperLimit = lowerLimit + endpoint.weight();
            RoundRobinPolicy.fineLog("upperLimit = {0}", upperLimit);
            if (random > lowerLimit && random <= upperLimit) {
                LinkedList<ClusterInstanceInfo> instanceInfo = new LinkedList<ClusterInstanceInfo>();
                instanceInfo.addAll(0, this.endpointsList.subList(i, this.endpointsList.size()));
                instanceInfo.addAll(this.endpointsList.subList(0, i));
                RoundRobinPolicy.fineLog("returning the following list...{0}", ((Object)instanceInfo).toString());
                return this.convertIntoCorbaloc(instanceInfo);
            }
            lowerLimit = upperLimit;
            RoundRobinPolicy.fineLog("lowerLimit = {0}", lowerLimit);
            ++i;
        }
        RoundRobinPolicy.warnLog("Could not find an endpoint to send request to!", new Object[0]);
        return null;
    }

    private Object[] convertIntoCorbaloc(List<ClusterInstanceInfo> list) {
        ArrayList<String> host_port = new ArrayList<String>();
        for (ClusterInstanceInfo endpoint : list) {
            List<SocketInfo> sinfos = endpoint.endpoints();
            for (SocketInfo si : sinfos) {
                String element = si.host().trim() + ":" + si.port();
                if (host_port.contains(element)) continue;
                host_port.add(element);
            }
        }
        return host_port.toArray();
    }

    private String[] getAddressPortList(String[] hostPortList) {
        ArrayList<String> addressPortVector = new ArrayList<String>();
        for (String str : hostPortList) {
            try {
                IiopUrl url = new IiopUrl("iiop://" + str);
                String[] apList = this.getAddressPortList(url);
                addressPortVector.addAll(Arrays.asList(apList));
            }
            catch (MalformedURLException me) {
                RoundRobinPolicy.warnLog("bad.host.port", str, me.getMessage());
            }
        }
        String[] ret = new String[addressPortVector.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)addressPortVector.get(i);
        }
        return ret;
    }

    private String[] getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address iiopUrlAddress = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String host = iiopUrlAddress.host;
        int portNumber = iiopUrlAddress.port;
        String port = Integer.toString(portNumber);
        return this.getAddressPortList(host, port);
    }

    public String[] getAddressPortList(String host, String port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            String[] ret = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                ret[i] = addresses[i].getHostAddress() + ":" + port;
            }
            return ret;
        }
        catch (UnknownHostException ukhe) {
            RoundRobinPolicy.warnLog("unknown.host", host, ukhe.getMessage());
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RoundRobinPolicy[");
        boolean first = true;
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(endpoint.toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

