/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.enterprise.naming.impl.GroupInfoServiceObserverImpl;
import com.sun.enterprise.naming.impl.RoundRobinPolicy;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.WrappedSerialContext;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

public class SerialInitContextFactory
implements InitialContextFactory {
    public static final String LOAD_BALANCING_PROPERTY = "com.sun.appserv.iiop.loadbalancingpolicy";
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private static final String IIOP_URL = "iiop:1.2@";
    private static final String CORBALOC = "corbaloc:";
    public static final String IC_BASED_WEIGHTED = "ic-based-weighted";
    public static final String IC_BASED = "ic-based";
    protected static final Logger _logger = LogDomains.getLogger(SerialInitContextFactory.class, (String)"javax.enterprise.system.core.naming");
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static String defaultHost;
    private static String defaultPort;
    private static Habitat defaultHabitat;
    private final Hashtable defaultEnv = new Hashtable();
    private final RoundRobinPolicy rrPolicy;
    private final boolean useLB;
    private final Habitat habitat = defaultHabitat == null ? Globals.getDefaultHabitat() : defaultHabitat;
    private final GroupInfoServiceObserverImpl giso;
    private GroupInfoService gis = null;

    public RoundRobinPolicy getRRPolicy() {
        return this.rrPolicy;
    }

    public static String getCorbalocURL(Object[] list) {
        String corbalocURL = "";
        for (int i = 0; i < list.length; ++i) {
            _logger.log(Level.INFO, "list[i] ==> {0}", list[i]);
            corbalocURL = corbalocURL.isEmpty() ? IIOP_URL + ((String)list[i]).trim() : corbalocURL + "," + IIOP_URL + ((String)list[i]).trim();
        }
        _logger.log(Level.INFO, "corbaloc url ==> {0}", corbalocURL);
        return corbalocURL;
    }

    private String[] getEndpointList() {
        String[] list;
        String[] commaDelimitedValues = null;
        String policy = null;
        String propertyValue = System.getProperty(LOAD_BALANCING_PROPERTY);
        if (propertyValue != null) {
            commaDelimitedValues = propertyValue.split(",");
            if (commaDelimitedValues != null && (commaDelimitedValues[0].trim().equals(IC_BASED) || commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED))) {
                policy = commaDelimitedValues[0];
            }
            if (policy != null) {
                System.setProperty(LOAD_BALANCING_PROPERTY, policy);
            }
        }
        if ((list = (propertyValue = System.getProperty(IIOP_ENDPOINTS_PROPERTY)) == null || propertyValue.length() == 0 ? null : propertyValue.split(",")) == null) {
            if (commaDelimitedValues != null && commaDelimitedValues.length > 1) {
                list = new String[commaDelimitedValues.length - 1];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = commaDelimitedValues[i + 1];
                }
            } else {
                String host = System.getProperty("org.omg.CORBA.ORBInitialHost");
                String port = System.getProperty("org.omg.CORBA.ORBInitialPort");
                if (host != null && port != null) {
                    list = new String[]{host + ":" + port};
                }
            }
        }
        return list;
    }

    private boolean propertyIsSet(String pname) {
        String value = System.getProperty(pname);
        return value != null && !value.isEmpty();
    }

    public SerialInitContextFactory() {
        this.useLB = this.propertyIsSet(IIOP_ENDPOINTS_PROPERTY) || this.propertyIsSet(LOAD_BALANCING_PROPERTY);
        if (this.useLB) {
            String[] list = this.getEndpointList();
            this.rrPolicy = new RoundRobinPolicy(list);
            if (list != null && list.length > 0) {
                try {
                    this.gis = (GroupInfoService)((Object)this.getORB().resolve_initial_references("FolbClientGroupInfoService"));
                }
                catch (InvalidName ex) {
                    _logger.log(Level.SEVERE, null, ex);
                }
            }
        } else {
            this.rrPolicy = null;
        }
        if (this.gis != null) {
            this.giso = new GroupInfoServiceObserverImpl(this.gis, this);
            this.gis.addObserver(this.giso);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "getGIS: rrPolicy = {0}", this.rrPolicy);
            }
        } else {
            this.giso = null;
        }
    }

    private ORB getORB() {
        ORBLocator orbLoc;
        Object result = null;
        if (this.habitat != null && (orbLoc = (ORBLocator)this.habitat.getByContract(ORBLocator.class)) != null) {
            return orbLoc.getORB();
        }
        throw new RuntimeException("Could not get ORB");
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (defaultHost != null && env.get("org.omg.CORBA.ORBInitialHost") == null) {
            env.put("org.omg.CORBA.ORBInitialHost", defaultHost);
        }
        if (defaultPort != null && env.get("org.omg.CORBA.ORBInitialPort") == null) {
            env.put("org.omg.CORBA.ORBInitialPort", defaultPort);
        }
        if (!initialized.get()) {
            boolean firstToInitialize = initialized.compareAndSet(false, true);
            if (firstToInitialize && this.habitat != null) {
                for (NamingObjectsProvider provider : this.habitat.getAllByContract(NamingObjectsProvider.class)) {
                }
            }
            String policy = null;
            if (this.useLB) {
                String[] temp_list;
                Context ctx;
                if (env == null) {
                    env = this.defaultEnv;
                }
                if ((ctx = SerialContext.getStickyContext()) != null) {
                    return ctx;
                }
                Object[] list = this.rrPolicy.getNextRotation();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "getInitialContext: rrPolicy = {0}", this.rrPolicy);
                }
                String corbalocURL = SerialInitContextFactory.getCorbalocURL(list);
                env.put("com.sun.appserv.ee.iiop.endpointslist", CORBALOC + corbalocURL);
                env.put("java.naming.corba.orb", this.getORB());
                String propertyValue = (String)env.get(LOAD_BALANCING_PROPERTY);
                String[] commaDelimitedValues = null;
                String host = null;
                String port = null;
                if (propertyValue != null) {
                    commaDelimitedValues = propertyValue.split(",");
                    if (commaDelimitedValues != null && (commaDelimitedValues[0].trim().equals(IC_BASED) || commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED))) {
                        policy = commaDelimitedValues[0];
                    }
                    if (policy != null) {
                        System.setProperty(LOAD_BALANCING_PROPERTY, policy);
                    }
                }
                String[] stringArray = temp_list = (propertyValue = (String)env.get(IIOP_ENDPOINTS_PROPERTY)) == null || propertyValue.length() == 0 ? null : propertyValue.split(",");
                if ((temp_list == null || temp_list.length == 0) && commaDelimitedValues != null) {
                    temp_list = new String[commaDelimitedValues.length - 1];
                    for (int i = 0; i < temp_list.length; ++i) {
                        temp_list[i] = commaDelimitedValues[i + 1];
                    }
                }
                if (System.getProperty(IIOP_ENDPOINTS_PROPERTY) == null && (temp_list == null || temp_list.length == 0)) {
                    if (env.get("java.naming.provider.url") != null) {
                        temp_list = this.rrPolicy.getEndpointForProviderURL((String)env.get("java.naming.provider.url"));
                    }
                    if (temp_list == null || temp_list.length == 0) {
                        if (env.get("org.omg.CORBA.ORBInitialHost") != null && env.get("org.omg.CORBA.ORBInitialPort") != null) {
                            host = (String)env.get("org.omg.CORBA.ORBInitialHost");
                            port = (String)env.get("org.omg.CORBA.ORBInitialPort");
                        } else {
                            host = System.getProperty("org.omg.CORBA.ORBInitialHost");
                            port = System.getProperty("org.omg.CORBA.ORBInitialPort");
                        }
                        if (host != null && port != null) {
                            temp_list = this.rrPolicy.getAddressPortList(host, port);
                            _logger.log(Level.WARNING, "no.endpoints.selected", new Object[]{host, port});
                        } else {
                            _logger.log(Level.SEVERE, "no.endpoints");
                            throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
                        }
                    }
                }
                if (this.giso == null) {
                    _logger.warning("Cannot obtain GroupInfoServiceObserverImpl");
                }
                if (temp_list != null && temp_list.length > 0) {
                    this.rrPolicy.setClusterInstanceInfo(temp_list);
                }
                if (this.giso != null) {
                    this.giso.membershipChange();
                } else {
                    _logger.warning("Cannot obtain GroupInfoServiceObserverImpl");
                }
            }
        }
        return this.createInitialContext(env != null ? env : this.defaultEnv);
    }

    private Context createInitialContext(Hashtable env) throws NamingException {
        SerialContext serialContext = new SerialContext(env, this.habitat);
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return new WrappedSerialContext(env, serialContext);
        }
        return serialContext;
    }

    static void setDefaultHost(String host) {
        defaultHost = host;
    }

    static void setDefaultPort(String port) {
        defaultPort = port;
    }

    static void setDefaultHabitat(Habitat h) {
        defaultHabitat = h;
    }

    static Habitat getDefaultHabitat() {
        return defaultHabitat;
    }
}

