/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.config.serverbeans.Node;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.IOException;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="uninstall-node")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class UninstallNodeCommand
extends CLICommand {
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true)
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=false, primary=true, multiple=true)
    private String[] hosts;
    @Param(name="install-location", optional=true)
    private String installLocation;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean promptPass = false;
    @Inject
    SSHLauncher sshLauncher;
    @Inject
    Node[] nodeList;

    protected void validate() throws CommandException {
        for (String host : this.hosts) {
            for (Node node : this.nodeList) {
                if (!node.getNodeHost().equals(host)) continue;
                throw new CommandException("delete-node-ssh needs to be called to delete node for " + host + " before uninstall-node is called");
            }
        }
    }

    protected int executeCommand() throws CommandException {
        try {
            String baseRootValue = this.executeLocationsCommand();
            this.deleteFromHosts(baseRootValue);
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void deleteFromHosts(String baseRootValue) throws IOException, InterruptedException {
        if (this.installLocation == null) {
            this.installLocation = baseRootValue;
        }
        for (String host : this.hosts) {
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            if (!sftpClient.exists(this.installLocation)) {
                throw new IOException(this.installLocation + " Directory does not exist");
            }
            this.deleteRemoteFiles(sftpClient, this.installLocation);
            sftpClient.rmdir(this.installLocation);
        }
    }

    private void deleteRemoteFiles(SFTPClient sftpClient, String dir) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(dir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..")) continue;
            if (directoryEntry.attributes.isDirectory()) {
                this.deleteRemoteFiles(sftpClient, dir + "/" + directoryEntry.filename);
                sftpClient.rmdir(dir + "/" + directoryEntry.filename);
                continue;
            }
            sftpClient.rm(dir + "/" + directoryEntry.filename);
        }
    }

    private String executeLocationsCommand() throws CommandException {
        RemoteCommand cmd = new RemoteCommand("__locations", this.programOpts, this.env);
        Map attrs = cmd.executeAndReturnAttributes(new String[]{"__locations"});
        return (String)attrs.get("Base-Root_value");
    }
}

