/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.FailureNotificationAction;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedAction;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationAction;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownAction;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.AliveAndReadyViewWindow;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureSuspectedSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GroupLeadershipNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinedAndReadyNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.SignalHandler;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Router {
    private final CopyOnWriteArrayList<FailureNotificationActionFactory> failureNotificationAF = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, FailureRecoveryActionFactory> failureRecoveryAF = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MessageActionFactory> messageAF = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<PlannedShutdownActionFactory> plannedShutdownAF = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JoinNotificationActionFactory> joinNotificationAF = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JoinedAndReadyNotificationActionFactory> joinedAndReadyNotificationAF = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<FailureSuspectedActionFactory> failureSuspectedAF = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<GroupLeadershipNotificationActionFactory> groupLeadershipNotificationAFs = new CopyOnWriteArrayList();
    private final BlockingQueue<SignalPacket> queue;
    private AtomicInteger queueHighWaterMark = new AtomicInteger(0);
    private final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private final ExecutorService actionPool;
    private long startupTime;
    private static final int GROUP_WARMUP_TIME = 30000;
    private final int MAX_QUEUE_SIZE;
    private final Thread signalHandlerThread;
    private SignalHandler signalHandler;
    public final AliveAndReadyViewWindow aliveAndReadyView;
    private ConcurrentHashMap<String, AtomicInteger> undeliveredMessages = new ConcurrentHashMap();

    public Router(int queueSize, AliveAndReadyViewWindow viewWindow) {
        this.aliveAndReadyView = viewWindow;
        this.MAX_QUEUE_SIZE = queueSize;
        this.queue = new ArrayBlockingQueue<SignalPacket>(this.MAX_QUEUE_SIZE);
        this.signalHandler = new SignalHandler(this.queue, this);
        this.signalHandlerThread = new Thread((Runnable)this.signalHandler, this.getClass().getCanonicalName() + " Thread");
        this.signalHandlerThread.start();
        this.actionPool = Executors.newCachedThreadPool();
        this.startupTime = System.currentTimeMillis();
    }

    void addDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.add(failureNotificationActionFactory);
    }

    void addDestination(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.failureRecoveryAF.put(componentName, failureRecoveryActionFactory);
    }

    void addDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.add(joinNotificationActionFactory);
    }

    void addDestination(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.joinedAndReadyNotificationAF.add(joinedAndReadyNotificationActionFactory);
    }

    void addDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.add(plannedShutdownActionFactory);
    }

    void addDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.add(failureSuspectedActionFactory);
    }

    void addDestination(MessageActionFactory messageActionFactory, String componentName) {
        this.messageAF.put(componentName, messageActionFactory);
    }

    void addDestination(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.groupLeadershipNotificationAFs.add(groupLeadershipNotificationActionFactory);
    }

    void removeDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.remove(failureNotificationActionFactory);
    }

    void removeDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.remove(joinNotificationActionFactory);
    }

    void removeDestination(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.joinedAndReadyNotificationAF.remove(joinedAndReadyNotificationActionFactory);
    }

    void removeDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.remove(plannedShutdownActionFactory);
    }

    void removeDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.remove(failureSuspectedActionFactory);
    }

    public void removeMessageAFDestination(String componentName) {
        this.messageAF.remove(componentName);
    }

    public void removeFailureRecoveryAFDestination(String componentName) {
        this.failureRecoveryAF.remove(componentName);
    }

    void removeDestination(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.groupLeadershipNotificationAFs.remove(groupLeadershipNotificationActionFactory);
    }

    public void queueSignals(SignalPacket signalPacket) {
        this.queueSignal(signalPacket);
    }

    private void recordQueueHighWaterMark() {
        int localHighWater;
        int currentQueueSize;
        if (this.monitorLogger.isLoggable(Level.FINE) && (currentQueueSize = this.queue.size()) > (localHighWater = this.queueHighWaterMark.get())) {
            this.queueHighWaterMark.compareAndSet(localHighWater, currentQueueSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSignal(SignalPacket signalPacket) {
        try {
            boolean result = this.queue.offer(signalPacket);
            if (!result) {
                int fullcapacity = this.queue.size();
                long starttime = System.currentTimeMillis();
                try {
                    this.queue.put(signalPacket);
                }
                finally {
                    long duration = System.currentTimeMillis() - starttime;
                    if (duration > 0L) {
                        this.monitorLogger.info("signal processing blocked due to signal queue being full for " + duration + " ms. Router signal queue capacity: " + fullcapacity);
                    }
                }
            }
            this.recordQueueHighWaterMark();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void undocketAllDestinations() {
        this.failureRecoveryAF.clear();
        this.failureNotificationAF.clear();
        this.plannedShutdownAF.clear();
        this.joinNotificationAF.clear();
        this.messageAF.clear();
        this.failureSuspectedAF.clear();
        this.groupLeadershipNotificationAFs.clear();
    }

    void notifyFailureNotificationAction(FailureNotificationSignal signal) {
        this.logger.log(Level.INFO, "failurenotificationsignals.send.member", new Object[]{signal.getMemberToken()});
        for (FailureNotificationActionFactory fnaf : this.failureNotificationAF) {
            FailureNotificationAction a = (FailureNotificationAction)fnaf.produceAction();
            this.callAction((Action)a, (Signal)new FailureNotificationSignalImpl(signal));
        }
    }

    void notifyFailureRecoveryAction(FailureRecoverySignal signal) {
        this.logger.log(Level.INFO, "failurenotificationsignals.send.component", new Object[]{signal.getComponentName()});
        FailureRecoveryActionFactory fraf = this.failureRecoveryAF.get(signal.getComponentName());
        FailureRecoveryAction a = (FailureRecoveryAction)fraf.produceAction();
        FailureRecoverySignalImpl frs = new FailureRecoverySignalImpl(signal);
        this.callAction((Action)a, (Signal)frs);
    }

    void notifyFailureSuspectedAction(FailureSuspectedSignal signal) {
        this.logger.log(Level.INFO, "failuresuspectedsignals.send.member", new Object[]{signal.getMemberToken()});
        for (FailureSuspectedActionFactory fsaf : this.failureSuspectedAF) {
            FailureSuspectedAction a = (FailureSuspectedAction)fsaf.produceAction();
            FailureSuspectedSignalImpl fss = new FailureSuspectedSignalImpl(signal);
            this.callAction((Action)a, (Signal)fss);
        }
    }

    private void notifyMessageAction(MessageSignal signal, String targetComponent) {
        MessageActionFactory maf = null;
        maf = this.messageAF.get(targetComponent);
        if (maf != null) {
            MessageAction a = (MessageAction)maf.produceAction();
            try {
                a.consumeSignal((Signal)signal);
            }
            catch (ActionException e) {
                this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "router.msg.handler.exception", new Object[]{t.getLocalizedMessage(), signal.toString()});
                this.logger.log(Level.WARNING, "stack trace", t);
            }
        }
    }

    void notifyMessageAction(MessageSignal signal) {
        String targetComponent = signal.getTargetComponent();
        if (targetComponent != null) {
            this.notifyMessageAction(signal, targetComponent);
        }
    }

    void notifyJoinNotificationAction(JoinNotificationSignal signal) {
        if (this.isJoinNotificationAFRegistered()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, MessageFormat.format("Sending JoinNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            }
            for (JoinNotificationActionFactory jnaf : this.joinNotificationAF) {
                JoinNotificationAction a = (JoinNotificationAction)jnaf.produceAction();
                JoinNotificationSignalImpl jns = new JoinNotificationSignalImpl(signal);
                this.callAction((Action)a, (Signal)jns);
            }
        } else if (System.currentTimeMillis() - this.startupTime < 30000L) {
            this.queueSignal(new SignalPacket((Signal)signal));
        }
    }

    void notifyJoinedAndReadyNotificationAction(JoinedAndReadyNotificationSignal signal) {
        if (this.isJoinedAndReadyNotificationAFRegistered()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, MessageFormat.format("Sending JoinedAndReadyNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            }
            for (JoinedAndReadyNotificationActionFactory jnaf : this.joinedAndReadyNotificationAF) {
                JoinedAndReadyNotificationAction a = (JoinedAndReadyNotificationAction)jnaf.produceAction();
                JoinedAndReadyNotificationSignalImpl jns = new JoinedAndReadyNotificationSignalImpl(signal);
                this.callAction((Action)a, (Signal)jns);
            }
        }
    }

    void notifyPlannedShutdownAction(PlannedShutdownSignal signal) {
        this.logger.log(Level.INFO, "plannedshutdownsignals.send.member", new Object[]{signal.getEventSubType(), signal.getMemberToken()});
        for (PlannedShutdownActionFactory psaf : this.plannedShutdownAF) {
            PlannedShutdownAction a = (PlannedShutdownAction)psaf.produceAction();
            PlannedShutdownSignalImpl pss = new PlannedShutdownSignalImpl(signal);
            this.callAction((Action)a, (Signal)pss);
        }
    }

    void notifyGroupLeadershipNotificationAction(GroupLeadershipNotificationSignal signal) {
        if (this.isGroupLeadershipNotificationAFRegistered()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, MessageFormat.format("Sending GroupLeadershipNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            }
            for (GroupLeadershipNotificationActionFactory glsnaf : this.groupLeadershipNotificationAFs) {
                GroupLeadershipNotificationAction a = (GroupLeadershipNotificationAction)glsnaf.produceAction();
                GroupLeadershipNotificationSignalImpl glsns = new GroupLeadershipNotificationSignalImpl(signal);
                this.callAction((Action)a, (Signal)glsns);
            }
        }
    }

    private void callAction(Action a, Signal signal) {
        try {
            CallableAction task = new CallableAction(a, signal);
            this.actionPool.submit(task);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, e.getMessage());
        }
    }

    public boolean isFailureNotificationAFRegistered() {
        boolean retval = true;
        if (this.failureNotificationAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isFailureRecoveryAFRegistered() {
        boolean retval = true;
        if (this.failureRecoveryAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isMessageAFRegistered() {
        boolean retval = true;
        if (this.messageAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isPlannedShutdownAFRegistered() {
        boolean retval = true;
        if (this.plannedShutdownAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isJoinNotificationAFRegistered() {
        boolean retval = true;
        if (this.joinNotificationAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isJoinedAndReadyNotificationAFRegistered() {
        boolean retval = true;
        if (this.joinedAndReadyNotificationAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isFailureSuspectedAFRegistered() {
        boolean retval = true;
        if (this.failureSuspectedAF.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    public boolean isGroupLeadershipNotificationAFRegistered() {
        boolean retval = true;
        if (this.groupLeadershipNotificationAFs.isEmpty()) {
            retval = false;
        }
        return retval;
    }

    Hashtable<String, FailureRecoveryActionFactory> getFailureRecoveryAFRegistrations() {
        return new Hashtable<String, FailureRecoveryActionFactory>(this.failureRecoveryAF);
    }

    public Set<String> getFailureRecoveryComponents() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("Router Returning failure recovery components={0}", this.failureRecoveryAF.keySet()));
        }
        return this.failureRecoveryAF.keySet();
    }

    public void shutdown() {
        this.undocketAllDestinations();
        if (this.signalHandlerThread != null) {
            this.signalHandler.stop(this.signalHandlerThread);
        }
        if (this.monitorLogger.isLoggable(Level.FINE)) {
            this.monitorLogger.log(Level.FINE, "router signal queue high water mark:" + this.queueHighWaterMark.get() + " signal queue capacity:" + this.MAX_QUEUE_SIZE);
        }
        if (this.queue != null) {
            int unprocessedEventSize = this.queue.size();
            if (unprocessedEventSize > 0) {
                this.logger.log(Level.WARNING, "router.shutdown.unprocessed", new Object[]{this.queue.size()});
                try {
                    LinkedList unprocessedEvents = new LinkedList();
                    this.queue.drainTo(unprocessedEvents);
                    for (SignalPacket sp : unprocessedEvents) {
                        this.logger.log(Level.INFO, "router.shutdown.unprocessed.signal", new Object[]{sp.toString()});
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.queue.clear();
        }
        if (this.actionPool != null) {
            this.actionPool.shutdownNow();
        }
    }

    private static class CallableAction
    implements Callable<Object> {
        private Action action;
        private Signal signal;

        CallableAction(Action action, Signal signal) {
            this.action = action;
            this.signal = signal;
        }

        @Override
        public Object call() throws ActionException {
            try {
                this.action.consumeSignal(this.signal);
            }
            catch (ActionException ae) {
                throw ae;
            }
            catch (Throwable t) {
                ActionException nae = new ActionException();
                nae.initCause(t);
                throw nae;
            }
            return null;
        }
    }
}

