/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.util.FileUtils;
import com.sun.enterprise.backup.util.ObjectAnalyzer;
import java.io.File;

public class BackupRequest {
    static final String[] excludeDirs = new String[]{"backups/"};
    File domainsDir;
    String domainName;
    String description;
    int recycleLimit = 0;
    File backupFile;
    File domainDir;
    long timestamp;
    File backupDir = null;
    boolean terse = false;
    boolean verbose = false;
    boolean force = false;

    public BackupRequest(String domainsDirName, String domain, String desc) {
        this.setDomainsDir(domainsDirName);
        this.setDescription(desc);
        this.domainName = domain;
    }

    public BackupRequest(String domainsDirName, String domain, String desc, String backupFileName) {
        this(domainsDirName, domain, desc);
        this.setBackupFile(backupFileName);
    }

    public BackupRequest(String domainsDirName, String domain, String desc, int limit) {
        this(domainsDirName, domain, desc);
        this.recycleLimit = limit;
    }

    public void setTerse(boolean b) {
        this.terse = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    private void setDomainsDir(String name) {
        this.domainsDir = FileUtils.safeGetCanonicalFile(new File(name));
    }

    private void setBackupFile(String name) {
        this.backupFile = FileUtils.safeGetCanonicalFile(new File(name));
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    public void setBackupDir(File dir) {
        this.backupDir = dir;
    }

    public void setForce(boolean f) {
        this.force = f;
    }
}

