/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.shoal.adapter.store.commands.SimpleAckCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public abstract class AcknowledgedCommand<K, V>
extends Command<K, V> {
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;

    protected AcknowledgedCommand(byte opCode) {
        super(opCode);
    }

    protected void writeAcknowledgementId(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        ros.writeLengthPrefixedString(this.originatingInstance);
    }

    public void readAcknowledgementId(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readLengthPrefixedString();
    }

    protected void sendAcknowledgement() {
        try {
            this.dsc.getCommandManager().execute(new SimpleAckCommand(this.originatingInstance, this.tokenId));
        }
        catch (DataStoreException dataStoreException) {
            // empty catch block
        }
    }

    protected void waitForAck() throws DataStoreException {
        try {
            this.future.get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException inEx) {
            throw new DataStoreException(inEx);
        }
        catch (ExecutionException exeEx) {
            throw new DataStoreException(exeEx);
        }
        catch (TimeoutException timEx) {
            super.reExecute();
        }
    }
}

