/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class LoadRequestCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private K key;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;
    private String replicaLocationHint;
    private int replicaIndex = 0;

    public LoadRequestCommand() {
        super((byte)35);
    }

    public LoadRequestCommand(K key, String target) {
        this();
        this.key = key;
        this.replicaLocationHint = target;
    }

    @Override
    protected LoadRequestCommand<K, V> createNewInstance() {
        return new LoadRequestCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        this.setTargetName(this.replicaLocationHint);
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
        ros.writeLengthPrefixedString(this.originatingInstance);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.originatingInstance = ris.readLengthPrefixedString();
    }

    @Override
    public void execute(String initiator) {
        try {
            Object v;
            DataStoreEntry e = this.dsc.getReplicaStore().getEntry(this.key);
            Object v2 = v = e == null ? null : (Object)e.getV();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, this.dsc.getInstanceName() + " RESULT load_request " + this.key + " => " + v);
            }
            if (!this.originatingInstance.equals(this.dsc.getInstanceName())) {
                LoadResponseCommand<K, Object> rsp = new LoadResponseCommand<K, Object>(this.key, v, this.tokenId);
                rsp.setOriginatingInstance(this.originatingInstance);
                this.getCommandManager().execute(rsp);
            } else {
                this.resp.setResult(e);
            }
        }
        catch (DataStoreException dsEx) {
            this.resp.setException(dsEx);
        }
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result " + timeoutEx);
            return null;
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

