/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class SimpleAckCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_response");
    private long tokenId;
    private String targetInstanceName;
    private String respondingInstanceName;

    public SimpleAckCommand() {
        super((byte)2);
    }

    public SimpleAckCommand(String targetInstanceName, long tokenId) {
        this();
        this.targetInstanceName = targetInstanceName;
        this.tokenId = tokenId;
    }

    @Override
    protected SimpleAckCommand<K, V> createNewInstance() {
        return new SimpleAckCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.targetInstanceName);
        ros.writeLong(this.tokenId);
        ros.writeLengthPrefixedString(this.targetInstanceName);
        ros.writeLengthPrefixedString(this.dsc.getInstanceName());
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.targetInstanceName = ris.readLengthPrefixedString();
        this.respondingInstanceName = ris.readLengthPrefixedString();
    }

    @Override
    public void execute(String initiator) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(true);
        }
    }

    public String toString() {
        return this.getName() + "()";
    }
}

