/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class StoreableRemoveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    protected static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.remove");
    private K key;
    private String target;

    public StoreableRemoveCommand() {
        super((byte)71);
    }

    public StoreableRemoveCommand(K key) {
        this();
        this.key = key;
    }

    @Override
    protected StoreableRemoveCommand<K, V> createNewInstance() {
        return new StoreableRemoveCommand<K, V>();
    }

    public void setTarget(String t) {
        this.target = t;
    }

    @Override
    public void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.writeAcknowledgementId(ros);
        }
        super.setTargetName(this.target);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.readAcknowledgementId(ris);
        }
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
    }

    @Override
    public void execute(String initiator) {
        this.dsc.getReplicaStore().remove(this.key);
        if (!this.dsc.isDoASyncReplication()) {
            super.sendAcknowledgement();
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

